/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.TxBlock;
import org.mapdb.TxEngine;
import org.mapdb.TxRollbackException;

public class TxMaker {
    protected static final Object DELETED = new Object();
    private final boolean txSnapshotsEnabled;
    private final boolean strictDBGet;
    protected Engine engine;

    public TxMaker(Engine engine) {
        this(engine, false, false);
    }

    public TxMaker(Engine engine, boolean strictDBGet, boolean txSnapshotsEnabled) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        if (!engine.canSnapshot()) {
            throw new IllegalArgumentException("Snapshot must be enabled for TxMaker");
        }
        if (engine.isReadOnly()) {
            throw new IllegalArgumentException("TxMaker can not be used with read-only Engine");
        }
        this.engine = engine;
        this.strictDBGet = strictDBGet;
        this.txSnapshotsEnabled = txSnapshotsEnabled;
    }

    public DB makeTx() {
        Engine snapshot = this.engine.snapshot();
        if (this.txSnapshotsEnabled) {
            snapshot = new TxEngine(snapshot, false);
        }
        return new DB(snapshot, this.strictDBGet, false);
    }

    public void close() {
        this.engine.close();
        this.engine = null;
    }

    public void execute(TxBlock txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                txBlock.tx(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return;
            }
            catch (TxRollbackException e2) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }

    public <A> A execute(Fun.Function1<A, DB> txBlock) {
        while (true) {
            DB tx = this.makeTx();
            try {
                A a = txBlock.run(tx);
                if (!tx.isClosed()) {
                    tx.commit();
                }
                return a;
            }
            catch (TxRollbackException e2) {
                if (tx.isClosed()) continue;
                tx.close();
                continue;
            }
            break;
        }
    }
}

