/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.osgi.impl;

import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.osgi.services.ProxyConfiguration;
import org.apache.http.protocol.HttpContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class OSGiHttpRoutePlanner
extends DefaultRoutePlanner {
    private static final String DOT = ".";
    public static final Pattern IP_MASK_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final BundleContext bundleContext;
    private final Map<String, ServiceRegistration> registeredConfigurations;

    public OSGiHttpRoutePlanner(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations) {
        super(null);
        this.bundleContext = bundleContext;
        this.registeredConfigurations = registeredConfigurations;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        ProxyConfiguration proxyConfiguration = null;
        HttpHost proxyHost = null;
        for (ServiceRegistration registration : this.registeredConfigurations.values()) {
            Object proxyConfigurationObject = this.bundleContext.getService(registration.getReference());
            if (proxyConfigurationObject == null || !(proxyConfiguration = (ProxyConfiguration)proxyConfigurationObject).isEnabled()) continue;
            for (String exception : proxyConfiguration.getProxyExceptions()) {
                if (!OSGiHttpRoutePlanner.createMatcher(exception).matches(target.getHostName())) continue;
                return null;
            }
            if (null != proxyHost) continue;
            proxyHost = new HttpHost(proxyConfiguration.getHostname(), proxyConfiguration.getPort());
        }
        return proxyHost;
    }

    private static HostMatcher createMatcher(String name2) {
        NetworkAddress na = NetworkAddress.parse(name2);
        if (na != null) {
            return new IPAddressMatcher(na);
        }
        if (name2.startsWith(DOT)) {
            return new DomainNameMatcher(name2);
        }
        return new HostNameMatcher(name2);
    }

    private static class NetworkAddress {
        final int address;
        final int mask;

        static NetworkAddress parse(String adrSpec) {
            Matcher nameMatcher;
            if (null != adrSpec && (nameMatcher = IP_MASK_PATTERN.matcher(adrSpec)).matches()) {
                try {
                    int i1 = NetworkAddress.toInt(nameMatcher.group(1), 255);
                    int i2 = NetworkAddress.toInt(nameMatcher.group(2), 255);
                    int i3 = NetworkAddress.toInt(nameMatcher.group(3), 255);
                    int i4 = NetworkAddress.toInt(nameMatcher.group(4), 255);
                    int ip = i1 << 24 | i2 << 16 | i3 << 8 | i4;
                    int mask = NetworkAddress.toInt(nameMatcher.group(4), 32);
                    mask = mask == 32 ? -1 : -1 - (-1 >>> mask);
                    return new NetworkAddress(ip, mask);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static int toInt(String value, int max2) {
            if (value == null || value.isEmpty()) {
                return max2;
            }
            int number = Integer.parseInt(value);
            if (number > max2) {
                number = max2;
            }
            return number;
        }

        NetworkAddress(int address, int mask) {
            this.address = address;
            this.mask = mask;
        }
    }

    private static class IPAddressMatcher
    implements HostMatcher {
        private final NetworkAddress address;

        IPAddressMatcher(NetworkAddress address) {
            this.address = address;
        }

        @Override
        public boolean matches(String host) {
            NetworkAddress hostAddress = NetworkAddress.parse(host);
            return hostAddress != null && this.address.address == (hostAddress.address & this.address.mask);
        }
    }

    private static class DomainNameMatcher
    implements HostMatcher {
        private final String domainName;

        DomainNameMatcher(String domainName) {
            this.domainName = domainName.toLowerCase(Locale.ROOT);
        }

        @Override
        public boolean matches(String host) {
            return host.toLowerCase(Locale.ROOT).endsWith(this.domainName);
        }
    }

    private static class HostNameMatcher
    implements HostMatcher {
        private final String hostName;

        HostNameMatcher(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public boolean matches(String host) {
            return this.hostName.equalsIgnoreCase(host);
        }
    }

    private static interface HostMatcher {
        public boolean matches(String var1);
    }
}

