/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public abstract class LogMergePolicy
extends MergePolicy {
    public static final double LEVEL_LOG_SPAN = 0.75;
    public static final int DEFAULT_MERGE_FACTOR = 10;
    public static final int DEFAULT_MAX_MERGE_DOCS = Integer.MAX_VALUE;
    public static final double DEFAULT_NO_CFS_RATIO = 0.1;
    protected int mergeFactor = 10;
    protected long minMergeSize;
    protected long maxMergeSize;
    protected long maxMergeSizeForForcedMerge = Long.MAX_VALUE;
    protected int maxMergeDocs = Integer.MAX_VALUE;
    protected boolean calibrateSizeByDeletes = true;

    public LogMergePolicy() {
        super(0.1, Long.MAX_VALUE);
    }

    protected boolean verbose(IndexWriter writer2) {
        return writer2 != null && writer2.infoStream.isEnabled("LMP");
    }

    protected void message(String message, IndexWriter writer2) {
        if (this.verbose(writer2)) {
            writer2.infoStream.message("LMP", message);
        }
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int mergeFactor) {
        if (mergeFactor < 2) {
            throw new IllegalArgumentException("mergeFactor cannot be less than 2");
        }
        this.mergeFactor = mergeFactor;
    }

    public void setCalibrateSizeByDeletes(boolean calibrateSizeByDeletes) {
        this.calibrateSizeByDeletes = calibrateSizeByDeletes;
    }

    public boolean getCalibrateSizeByDeletes() {
        return this.calibrateSizeByDeletes;
    }

    protected long sizeDocs(SegmentCommitInfo info2, IndexWriter writer2) throws IOException {
        if (this.calibrateSizeByDeletes) {
            int delCount = writer2.numDeletedDocs(info2);
            assert (delCount <= info2.info.maxDoc());
            return (long)info2.info.maxDoc() - (long)delCount;
        }
        return info2.info.maxDoc();
    }

    protected long sizeBytes(SegmentCommitInfo info2, IndexWriter writer2) throws IOException {
        if (this.calibrateSizeByDeletes) {
            return super.size(info2, writer2);
        }
        return info2.sizeInBytes();
    }

    protected boolean isMerged(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer2) throws IOException {
        int numSegments = infos.size();
        int numToMerge = 0;
        SegmentCommitInfo mergeInfo = null;
        boolean segmentIsOriginal = false;
        for (int i = 0; i < numSegments && numToMerge <= maxNumSegments; ++i) {
            SegmentCommitInfo info2 = infos.info(i);
            Boolean isOriginal = segmentsToMerge.get(info2);
            if (isOriginal == null) continue;
            segmentIsOriginal = isOriginal;
            ++numToMerge;
            mergeInfo = info2;
        }
        return numToMerge <= maxNumSegments && (numToMerge != 1 || !segmentIsOriginal || this.isMerged(infos, mergeInfo, writer2));
    }

    private MergePolicy.MergeSpecification findForcedMergesSizeLimit(SegmentInfos infos, int maxNumSegments, int last, IndexWriter writer2) throws IOException {
        int start;
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        for (start = last - 1; start >= 0; --start) {
            SegmentCommitInfo info2 = infos.info(start);
            if (this.size(info2, writer2) > this.maxMergeSizeForForcedMerge || this.sizeDocs(info2, writer2) > (long)this.maxMergeDocs) {
                if (this.verbose(writer2)) {
                    this.message("findForcedMergesSizeLimit: skip segment=" + info2 + ": size is > maxMergeSize (" + this.maxMergeSizeForForcedMerge + ") or sizeDocs is > maxMergeDocs (" + this.maxMergeDocs + ")", writer2);
                }
                if (last - start - 1 > 1 || start != last - 1 && !this.isMerged(infos, infos.info(start + 1), writer2)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(start + 1, last)));
                }
                last = start;
                continue;
            }
            if (last - start != this.mergeFactor) continue;
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last)));
            last = start;
        }
        if (!(last <= 0 || ++start + 1 >= last && this.isMerged(infos, infos.info(start), writer2))) {
            spec.add(new MergePolicy.OneMerge(segments.subList(start, last)));
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    private MergePolicy.MergeSpecification findForcedMergesMaxNumSegments(SegmentInfos infos, int maxNumSegments, int last, IndexWriter writer2) throws IOException {
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        List<SegmentCommitInfo> segments = infos.asList();
        while (last - maxNumSegments + 1 >= this.mergeFactor) {
            spec.add(new MergePolicy.OneMerge(segments.subList(last - this.mergeFactor, last)));
            last -= this.mergeFactor;
        }
        if (0 == spec.merges.size()) {
            if (maxNumSegments == 1) {
                if (last > 1 || !this.isMerged(infos, infos.info(0), writer2)) {
                    spec.add(new MergePolicy.OneMerge(segments.subList(0, last)));
                }
            } else if (last > maxNumSegments) {
                int finalMergeSize = last - maxNumSegments + 1;
                long bestSize = 0L;
                int bestStart = 0;
                for (int i = 0; i < last - finalMergeSize + 1; ++i) {
                    long sumSize = 0L;
                    for (int j = 0; j < finalMergeSize; ++j) {
                        sumSize += this.size(infos.info(j + i), writer2);
                    }
                    if (i != 0 && (sumSize >= 2L * this.size(infos.info(i - 1), writer2) || sumSize >= bestSize)) continue;
                    bestStart = i;
                    bestSize = sumSize;
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(bestStart, bestStart + finalMergeSize)));
            }
        }
        return spec.merges.size() == 0 ? null : spec;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos infos, int maxNumSegments, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer2) throws IOException {
        assert (maxNumSegments > 0);
        if (this.verbose(writer2)) {
            this.message("findForcedMerges: maxNumSegs=" + maxNumSegments + " segsToMerge=" + segmentsToMerge, writer2);
        }
        if (this.isMerged(infos, maxNumSegments, segmentsToMerge, writer2)) {
            if (this.verbose(writer2)) {
                this.message("already merged; skip", writer2);
            }
            return null;
        }
        int last = infos.size();
        while (last > 0) {
            SegmentCommitInfo info2;
            if (segmentsToMerge.get(info2 = infos.info(--last)) == null) continue;
            ++last;
            break;
        }
        if (last == 0) {
            if (this.verbose(writer2)) {
                this.message("last == 0; skip", writer2);
            }
            return null;
        }
        if (maxNumSegments == 1 && last == 1 && this.isMerged(infos, infos.info(0), writer2)) {
            if (this.verbose(writer2)) {
                this.message("already 1 seg; skip", writer2);
            }
            return null;
        }
        boolean anyTooLarge = false;
        for (int i = 0; i < last; ++i) {
            SegmentCommitInfo info3 = infos.info(i);
            if (this.size(info3, writer2) <= this.maxMergeSizeForForcedMerge && this.sizeDocs(info3, writer2) <= (long)this.maxMergeDocs) continue;
            anyTooLarge = true;
            break;
        }
        if (anyTooLarge) {
            return this.findForcedMergesSizeLimit(infos, maxNumSegments, last, writer2);
        }
        return this.findForcedMergesMaxNumSegments(infos, maxNumSegments, last, writer2);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer2) throws IOException {
        List<SegmentCommitInfo> segments = segmentInfos.asList();
        int numSegments = segments.size();
        if (this.verbose(writer2)) {
            this.message("findForcedDeleteMerges: " + numSegments + " segments", writer2);
        }
        MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
        int firstSegmentWithDeletions = -1;
        assert (writer2 != null);
        for (int i = 0; i < numSegments; ++i) {
            SegmentCommitInfo info2 = segmentInfos.info(i);
            int delCount = writer2.numDeletedDocs(info2);
            if (delCount > 0) {
                if (this.verbose(writer2)) {
                    this.message("  segment " + info2.info.name + " has deletions", writer2);
                }
                if (firstSegmentWithDeletions == -1) {
                    firstSegmentWithDeletions = i;
                    continue;
                }
                if (i - firstSegmentWithDeletions != this.mergeFactor) continue;
                if (this.verbose(writer2)) {
                    this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", writer2);
                }
                spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
                firstSegmentWithDeletions = i;
                continue;
            }
            if (firstSegmentWithDeletions == -1) continue;
            if (this.verbose(writer2)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (i - 1) + " inclusive", writer2);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, i)));
            firstSegmentWithDeletions = -1;
        }
        if (firstSegmentWithDeletions != -1) {
            if (this.verbose(writer2)) {
                this.message("  add merge " + firstSegmentWithDeletions + " to " + (numSegments - 1) + " inclusive", writer2);
            }
            spec.add(new MergePolicy.OneMerge(segments.subList(firstSegmentWithDeletions, numSegments)));
        }
        return spec;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, IndexWriter writer2) throws IOException {
        int numSegments = infos.size();
        if (this.verbose(writer2)) {
            this.message("findMerges: " + numSegments + " segments", writer2);
        }
        ArrayList<SegmentInfoAndLevel> levels = new ArrayList<SegmentInfoAndLevel>();
        float norm = (float)Math.log(this.mergeFactor);
        Collection<SegmentCommitInfo> mergingSegments = writer2.getMergingSegments();
        for (int i = 0; i < numSegments; ++i) {
            String extra;
            SegmentCommitInfo info2 = infos.info(i);
            long size = this.size(info2, writer2);
            if (size < 1L) {
                size = 1L;
            }
            SegmentInfoAndLevel infoLevel = new SegmentInfoAndLevel(info2, (float)Math.log(size) / norm, i);
            levels.add(infoLevel);
            if (!this.verbose(writer2)) continue;
            long segBytes = this.sizeBytes(info2, writer2);
            String string2 = extra = mergingSegments.contains(info2) ? " [merging]" : "";
            if (size >= this.maxMergeSize) {
                extra = extra + " [skip: too large]";
            }
            this.message("seg=" + writer2.segString(info2) + " level=" + infoLevel.level + " size=" + String.format(Locale.ROOT, "%.3f MB", (double)(segBytes / 1024L) / 1024.0) + extra, writer2);
        }
        float levelFloor = this.minMergeSize <= 0L ? 0.0f : (float)(Math.log(this.minMergeSize) / (double)norm);
        MergePolicy.MergeSpecification spec = null;
        int numMergeableSegments = levels.size();
        int start = 0;
        while (start < numMergeableSegments) {
            int upto;
            float levelBottom;
            float maxLevel = ((SegmentInfoAndLevel)levels.get((int)start)).level;
            for (int i = 1 + start; i < numMergeableSegments; ++i) {
                float level = ((SegmentInfoAndLevel)levels.get((int)i)).level;
                if (!(level > maxLevel)) continue;
                maxLevel = level;
            }
            if (maxLevel <= levelFloor) {
                levelBottom = -1.0f;
            } else {
                levelBottom = (float)((double)maxLevel - 0.75);
                if (levelBottom < levelFloor && maxLevel >= levelFloor) {
                    levelBottom = levelFloor;
                }
            }
            for (upto = numMergeableSegments - 1; upto >= start && !(((SegmentInfoAndLevel)levels.get((int)upto)).level >= levelBottom); --upto) {
            }
            if (this.verbose(writer2)) {
                this.message("  level " + levelBottom + " to " + maxLevel + ": " + (1 + upto - start) + " segments", writer2);
            }
            int end = start + this.mergeFactor;
            while (end <= 1 + upto) {
                boolean anyTooLarge = false;
                boolean anyMerging = false;
                for (int i = start; i < end; ++i) {
                    SegmentCommitInfo info3 = ((SegmentInfoAndLevel)levels.get((int)i)).info;
                    anyTooLarge |= this.size(info3, writer2) >= this.maxMergeSize || this.sizeDocs(info3, writer2) >= (long)this.maxMergeDocs;
                    if (!mergingSegments.contains(info3)) continue;
                    anyMerging = true;
                    break;
                }
                if (!anyMerging) {
                    if (!anyTooLarge) {
                        if (spec == null) {
                            spec = new MergePolicy.MergeSpecification();
                        }
                        ArrayList<SegmentCommitInfo> mergeInfos = new ArrayList<SegmentCommitInfo>();
                        for (int i = start; i < end; ++i) {
                            mergeInfos.add(((SegmentInfoAndLevel)levels.get((int)i)).info);
                            assert (infos.contains(((SegmentInfoAndLevel)levels.get((int)i)).info));
                        }
                        if (this.verbose(writer2)) {
                            this.message("  add merge=" + writer2.segString(mergeInfos) + " start=" + start + " end=" + end, writer2);
                        }
                        spec.add(new MergePolicy.OneMerge(mergeInfos));
                    } else if (this.verbose(writer2)) {
                        this.message("    " + start + " to " + end + ": contains segment over maxMergeSize or maxMergeDocs; skipping", writer2);
                    }
                }
                start = end;
                end = start + this.mergeFactor;
            }
            start = 1 + upto;
        }
        return spec;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + this.getClass().getSimpleName() + ": ");
        sb.append("minMergeSize=").append(this.minMergeSize).append(", ");
        sb.append("mergeFactor=").append(this.mergeFactor).append(", ");
        sb.append("maxMergeSize=").append(this.maxMergeSize).append(", ");
        sb.append("maxMergeSizeForForcedMerge=").append(this.maxMergeSizeForForcedMerge).append(", ");
        sb.append("calibrateSizeByDeletes=").append(this.calibrateSizeByDeletes).append(", ");
        sb.append("maxMergeDocs=").append(this.maxMergeDocs).append(", ");
        sb.append("maxCFSSegmentSizeMB=").append(this.getMaxCFSSegmentSizeMB()).append(", ");
        sb.append("noCFSRatio=").append(this.noCFSRatio);
        sb.append("]");
        return sb.toString();
    }

    private static class SegmentInfoAndLevel
    implements Comparable<SegmentInfoAndLevel> {
        SegmentCommitInfo info;
        float level;
        int index;

        public SegmentInfoAndLevel(SegmentCommitInfo info2, float level, int index2) {
            this.info = info2;
            this.level = level;
            this.index = index2;
        }

        @Override
        public int compareTo(SegmentInfoAndLevel other) {
            return Float.compare(other.level, this.level);
        }
    }
}

