/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="System.out required: command line tool")
public class MultiPassIndexSplitter {
    public void split(IndexReader in, Directory[] outputs, boolean seq) throws IOException {
        if (outputs == null || outputs.length < 2) {
            throw new IOException("Invalid number of outputs.");
        }
        if (in == null || in.numDocs() < 2) {
            throw new IOException("Not enough documents for splitting");
        }
        int numParts = outputs.length;
        FakeDeleteIndexReader input = new FakeDeleteIndexReader(in);
        int maxDoc = input.maxDoc();
        int partLen = maxDoc / numParts;
        for (int i = 0; i < numParts; ++i) {
            input.undeleteAll();
            if (seq) {
                int j;
                int lo = partLen * i;
                int hi = lo + partLen;
                for (j = 0; j < lo; ++j) {
                    input.deleteDocument(j);
                }
                if (i < numParts - 1) {
                    for (j = hi; j < maxDoc; ++j) {
                        input.deleteDocument(j);
                    }
                }
            } else {
                for (int j = 0; j < maxDoc; ++j) {
                    if ((j + numParts - i) % numParts == 0) continue;
                    input.deleteDocument(j);
                }
            }
            IndexWriter w = new IndexWriter(outputs[i], new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            System.err.println("Writing part " + (i + 1) + " ...");
            List sr = input.getSequentialSubReaders();
            w.addIndexes(sr.toArray(new CodecReader[sr.size()]));
            w.close();
        }
        System.err.println("Done.");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: MultiPassIndexSplitter -out <outputDir> -num <numParts> [-seq] <inputIndex1> [<inputIndex2 ...]");
            System.err.println("\tinputIndex\tpath to input index, multiple values are ok");
            System.err.println("\t-out ouputDir\tpath to output directory to contain partial indexes");
            System.err.println("\t-num numParts\tnumber of parts to produce");
            System.err.println("\t-seq\tsequential docid-range split (default is round-robin)");
            System.exit(-1);
        }
        ArrayList<DirectoryReader> indexes = new ArrayList<DirectoryReader>();
        String outDir = null;
        int numParts = -1;
        boolean seq = false;
        for (int i = 0; i < args.length; ++i) {
            FSDirectory dir2;
            block13: {
                if (args[i].equals("-out")) {
                    outDir = args[++i];
                    continue;
                }
                if (args[i].equals("-num")) {
                    numParts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seq")) {
                    seq = true;
                    continue;
                }
                Path file2 = Paths.get(args[i], new String[0]);
                if (!Files.isDirectory(file2, new LinkOption[0])) {
                    System.err.println("Invalid input path - skipping: " + file2);
                    continue;
                }
                dir2 = FSDirectory.open(file2);
                try {
                    if (!DirectoryReader.indexExists(dir2)) {
                        System.err.println("Invalid input index - skipping: " + file2);
                    }
                    break block13;
                }
                catch (Exception e2) {
                    System.err.println("Invalid input index - skipping: " + file2);
                }
                continue;
            }
            indexes.add(DirectoryReader.open(dir2));
        }
        if (outDir == null) {
            throw new Exception("Required argument missing: -out outputDir");
        }
        if (numParts < 2) {
            throw new Exception("Invalid value of required argument: -num numParts");
        }
        if (indexes.size() == 0) {
            throw new Exception("No input indexes to process");
        }
        Path out = Paths.get(outDir, new String[0]);
        Files.createDirectories(out, new FileAttribute[0]);
        Directory[] dirs = new Directory[numParts];
        for (int i = 0; i < numParts; ++i) {
            dirs[i] = FSDirectory.open(out.resolve("part-" + i));
        }
        MultiPassIndexSplitter splitter = new MultiPassIndexSplitter();
        IndexReader input = indexes.size() == 1 ? (IndexReader)indexes.get(0) : new MultiReader(indexes.toArray(new IndexReader[indexes.size()]));
        splitter.split(input, dirs, seq);
    }

    private static final class FakeDeleteLeafIndexReader
    extends FilterCodecReader {
        FixedBitSet liveDocs;

        public FakeDeleteLeafIndexReader(CodecReader reader2) {
            super(reader2);
            this.undeleteAll();
        }

        @Override
        public int numDocs() {
            return this.liveDocs.cardinality();
        }

        public void undeleteAll() {
            int maxDoc = this.in.maxDoc();
            this.liveDocs = new FixedBitSet(this.in.maxDoc());
            if (this.in.hasDeletions()) {
                Bits oldLiveDocs = this.in.getLiveDocs();
                assert (oldLiveDocs != null);
                for (int i = 0; i < maxDoc; ++i) {
                    if (!oldLiveDocs.get(i)) continue;
                    this.liveDocs.set(i);
                }
            } else {
                this.liveDocs.set(0, maxDoc);
            }
        }

        public void deleteDocument(int n) {
            this.liveDocs.clear(n);
        }

        @Override
        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }

    private static final class FakeDeleteIndexReader
    extends BaseCompositeReader<FakeDeleteLeafIndexReader> {
        public FakeDeleteIndexReader(IndexReader reader2) throws IOException {
            super((IndexReader[])FakeDeleteIndexReader.initSubReaders(reader2));
        }

        private static FakeDeleteLeafIndexReader[] initSubReaders(IndexReader reader2) throws IOException {
            List<LeafReaderContext> leaves = reader2.leaves();
            FakeDeleteLeafIndexReader[] subs2 = new FakeDeleteLeafIndexReader[leaves.size()];
            int i = 0;
            for (LeafReaderContext ctx : leaves) {
                subs2[i++] = new FakeDeleteLeafIndexReader(SlowCodecReaderWrapper.wrap(ctx.reader()));
            }
            return subs2;
        }

        public void deleteDocument(int docID) {
            int i = this.readerIndex(docID);
            ((FakeDeleteLeafIndexReader)this.getSequentialSubReaders().get(i)).deleteDocument(docID - this.readerBase(i));
        }

        public void undeleteAll() {
            for (FakeDeleteLeafIndexReader r : this.getSequentialSubReaders()) {
                r.undeleteAll();
            }
        }

        @Override
        protected void doClose() {
        }
    }
}

