/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

class BytesRefIteratorTokenStream
extends TokenStream {
    private final BRTermToBytesRefAttributeImpl bytesAtt;
    private BytesRefIterator bytesIter = null;

    public BytesRefIteratorTokenStream() {
        super(new BRAttributeFactory(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY));
        this.addAttributeImpl(new BRTermToBytesRefAttributeImpl());
        this.bytesAtt = (BRTermToBytesRefAttributeImpl)this.addAttribute(TermToBytesRefAttribute.class);
    }

    public BytesRefIterator getBytesRefIterator() {
        return this.bytesIter;
    }

    public BytesRefIteratorTokenStream setBytesRefIterator(BytesRefIterator iter) {
        this.bytesIter = iter;
        return this;
    }

    @Override
    public void reset() throws IOException {
        if (this.bytesIter == null) {
            throw new IllegalStateException("call setBytesRefIterator() before usage");
        }
        this.bytesAtt.getBytesRef().length = 0;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.bytesIter == null) {
            throw new IllegalStateException("call setBytesRefIterator() before usage");
        }
        this.clearAttributes();
        BytesRef bytes2 = this.bytesIter.next();
        if (bytes2 == null) {
            return false;
        }
        this.bytesAtt.setBytesRef(bytes2);
        return true;
    }

    private static final class BRTermToBytesRefAttributeImpl
    extends AttributeImpl
    implements TermToBytesRefAttribute {
        private final BytesRef bytes = new BytesRef();

        private BRTermToBytesRefAttributeImpl() {
        }

        void setBytesRef(BytesRef inputBytes) {
            this.bytes.bytes = inputBytes.bytes;
            this.bytes.offset = inputBytes.offset;
            this.bytes.length = inputBytes.length;
        }

        @Override
        public void clear() {
        }

        @Override
        public void copyTo(AttributeImpl target) {
            BRTermToBytesRefAttributeImpl a = (BRTermToBytesRefAttributeImpl)target;
            a.setBytesRef(BytesRef.deepCopyOf(this.bytes));
        }

        @Override
        public void fillBytesRef() {
        }

        @Override
        public BytesRef getBytesRef() {
            return this.bytes;
        }

        @Override
        public BRTermToBytesRefAttributeImpl clone() {
            BRTermToBytesRefAttributeImpl clone = new BRTermToBytesRefAttributeImpl();
            clone.setBytesRef(BytesRef.deepCopyOf(this.bytes));
            return clone;
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BRTermToBytesRefAttributeImpl other = (BRTermToBytesRefAttributeImpl)obj;
            return this.bytes.equals(other.bytes);
        }
    }

    private static final class BRAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        BRAttributeFactory(AttributeFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            if (CharTermAttribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException(this.getClass() + " does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(attClass);
        }
    }
}

