/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.PrefixTreeFacetCounter;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.ArrayUtil;

public class HeatmapFacetCounter {
    public static final int MAX_ROWS_OR_COLUMNS = (int)Math.sqrt(ArrayUtil.MAX_ARRAY_LENGTH);

    public static Heatmap calcFacets(PrefixTreeStrategy strategy, IndexReaderContext context, Filter filter2, Shape inputShape, final int facetLevel, int maxCells) throws IOException {
        double heatMaxX;
        if (maxCells > MAX_ROWS_OR_COLUMNS * MAX_ROWS_OR_COLUMNS) {
            throw new IllegalArgumentException("maxCells (" + maxCells + ") should be <= " + MAX_ROWS_OR_COLUMNS);
        }
        if (inputShape == null) {
            inputShape = strategy.getSpatialContext().getWorldBounds();
        }
        Rectangle inputRect = inputShape.getBoundingBox();
        SpatialPrefixTree grid = strategy.getGrid();
        SpatialContext ctx = grid.getSpatialContext();
        Point cornerPt = ctx.makePoint(inputRect.getMinX(), inputRect.getMinY());
        CellIterator cellIterator = grid.getTreeCellIterator(cornerPt, facetLevel);
        Cell cornerCell = null;
        while (cellIterator.hasNext()) {
            cornerCell = cellIterator.next();
        }
        assert (cornerCell != null && cornerCell.getLevel() == facetLevel) : "Cell not at target level: " + cornerCell;
        Rectangle cornerRect = (Rectangle)cornerCell.getShape();
        assert (cornerRect.hasArea());
        double heatMinX = cornerRect.getMinX();
        final double cellWidth = cornerRect.getWidth();
        Rectangle worldRect = ctx.getWorldBounds();
        int columns = HeatmapFacetCounter.calcRowsOrCols(cellWidth, heatMinX, inputRect.getWidth(), inputRect.getMinX(), worldRect.getWidth());
        final double heatMinY = cornerRect.getMinY();
        final double cellHeight = cornerRect.getHeight();
        int rows = HeatmapFacetCounter.calcRowsOrCols(cellHeight, heatMinY, inputRect.getHeight(), inputRect.getMinY(), worldRect.getHeight());
        assert (rows > 0 && columns > 0);
        if (columns > MAX_ROWS_OR_COLUMNS || rows > MAX_ROWS_OR_COLUMNS || columns * rows > maxCells) {
            throw new IllegalArgumentException("Too many cells (" + columns + " x " + rows + ") for level " + facetLevel + " shape " + inputRect);
        }
        double halfCellWidth = cellWidth / 2.0;
        if ((double)columns * cellWidth + halfCellWidth > worldRect.getWidth()) {
            heatMinX = worldRect.getMinX();
        }
        if (Math.abs((heatMaxX = heatMinX + (double)columns * cellWidth) - worldRect.getMaxX()) < halfCellWidth) {
            heatMaxX = worldRect.getMaxX();
        } else if (heatMaxX > worldRect.getMaxX()) {
            heatMaxX = heatMaxX - worldRect.getMaxX() + worldRect.getMinX();
        }
        double halfCellHeight = cellHeight / 2.0;
        double heatMaxY = heatMinY + (double)rows * cellHeight;
        if (Math.abs(heatMaxY - worldRect.getMaxY()) < halfCellHeight) {
            heatMaxY = worldRect.getMaxY();
        }
        final Heatmap heatmap = new Heatmap(columns, rows, ctx.makeRectangle(heatMinX, heatMaxX, heatMinY, heatMaxY));
        final int[] allCellsAncestorCount = new int[1];
        final HashMap ancestors2 = new HashMap();
        PrefixTreeFacetCounter.compute(strategy, context, filter2, inputShape, facetLevel, new PrefixTreeFacetCounter.FacetVisitor(){

            @Override
            public void visit(Cell cell, int count2) {
                double heatMinX = heatmap.region.getMinX();
                Rectangle rect = (Rectangle)cell.getShape();
                if (cell.getLevel() == facetLevel) {
                    int column = rect.getMinX() >= heatMinX ? (int)Math.round((rect.getMinX() - heatMinX) / cellWidth) : (int)Math.round((rect.getMinX() + 360.0 - heatMinX) / cellWidth);
                    int row = (int)Math.round((rect.getMinY() - heatMinY) / cellHeight);
                    if (column < 0 || column >= heatmap.columns || row < 0 || row >= heatmap.rows) {
                        return;
                    }
                    int n = column * heatmap.rows + row;
                    heatmap.counts[n] = heatmap.counts[n] + count2;
                } else if (rect.relate(heatmap.region) == SpatialRelation.CONTAINS) {
                    allCellsAncestorCount[0] = allCellsAncestorCount[0] + count2;
                } else {
                    Integer existingCount = ancestors2.put(rect, count2);
                    if (existingCount != null) {
                        ancestors2.put(rect, count2 + existingCount);
                    }
                }
            }
        });
        if (allCellsAncestorCount[0] > 0) {
            int i = 0;
            while (i < heatmap.counts.length) {
                int n = i++;
                heatmap.counts[n] = heatmap.counts[n] + allCellsAncestorCount[0];
            }
        }
        int[] pair = new int[2];
        for (Map.Entry entry : ancestors2.entrySet()) {
            int endCol;
            int startCol;
            Rectangle rect = (Rectangle)entry.getKey();
            int count2 = (Integer)entry.getValue();
            HeatmapFacetCounter.intersectInterval(heatMinY, heatMaxY, cellHeight, rows, rect.getMinY(), rect.getMaxY(), pair);
            int startRow = pair[0];
            int endRow = pair[1];
            if (!heatmap.region.getCrossesDateLine()) {
                HeatmapFacetCounter.intersectInterval(heatMinX, heatMaxX, cellWidth, columns, rect.getMinX(), rect.getMaxX(), pair);
                int startCol2 = pair[0];
                int endCol2 = pair[1];
                HeatmapFacetCounter.incrementRange(heatmap, startCol2, endCol2, startRow, endRow, count2);
                continue;
            }
            if (rect.getMaxX() >= heatMinX) {
                int leftColumns = (int)Math.round((180.0 - heatMinX) / cellWidth) + 1;
                HeatmapFacetCounter.intersectInterval(heatMinX, 180.0, cellWidth, leftColumns, rect.getMinX(), rect.getMaxX(), pair);
                startCol = pair[0];
                endCol = pair[1];
                HeatmapFacetCounter.incrementRange(heatmap, startCol, endCol, startRow, endRow, count2);
            }
            if (!(rect.getMinY() <= heatMaxX)) continue;
            int rightColumns = (int)Math.round(heatMaxX / cellWidth) + 1;
            HeatmapFacetCounter.intersectInterval(0.0, heatMaxX, cellWidth, rightColumns, rect.getMinX(), rect.getMaxX(), pair);
            startCol = pair[0];
            endCol = pair[1];
            HeatmapFacetCounter.incrementRange(heatmap, startCol, endCol, startRow, endRow, count2);
        }
        return heatmap;
    }

    private static void intersectInterval(double heatMin, double heatMax, double heatCellLen, int heatLen, double cellMin, double cellMax, int[] out) {
        out[0] = heatMin >= cellMin ? 0 : (int)Math.round((cellMin - heatMin) / heatCellLen);
        out[1] = heatMax <= cellMax ? heatLen - 1 : (int)Math.round((cellMax - heatMin) / heatCellLen) - 1;
    }

    private static void incrementRange(Heatmap heatmap, int startColumn, int endColumn, int startRow, int endRow, int count2) {
        if (startColumn < 0) {
            endColumn += startColumn;
            startColumn = 0;
        }
        endColumn = Math.min(heatmap.columns - 1, endColumn);
        if (startRow < 0) {
            endRow += startRow;
            startRow = 0;
        }
        if (startRow > (endRow = Math.min(heatmap.rows - 1, endRow))) {
            return;
        }
        for (int c = startColumn; c <= endColumn; ++c) {
            int cBase = c * heatmap.rows;
            for (int r = startRow; r <= endRow; ++r) {
                int n = cBase + r;
                heatmap.counts[n] = heatmap.counts[n] + count2;
            }
        }
    }

    private static int calcRowsOrCols(double cellRange, double cellMin, double requestRange, double requestMin, double worldRange) {
        assert (requestMin >= cellMin);
        double range2 = requestRange + (requestMin - cellMin);
        if (range2 == 0.0) {
            return 1;
        }
        double intervals = Math.ceil(range2 / cellRange);
        if (intervals > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        long intervalsMax = Math.round(worldRange / cellRange);
        if (intervalsMax > Integer.MAX_VALUE) {
            return (int)intervals;
        }
        return Math.min((int)intervalsMax, (int)intervals);
    }

    private HeatmapFacetCounter() {
    }

    public static class Heatmap {
        public final int columns;
        public final int rows;
        public final int[] counts;
        public final Rectangle region;

        public Heatmap(int columns, int rows, Rectangle region) {
            this.columns = columns;
            this.rows = rows;
            this.counts = new int[columns * rows];
            this.region = region;
        }

        public int getCount(int x, int y) {
            return this.counts[x * this.rows + y];
        }

        public String toString() {
            return "Heatmap{" + this.columns + "x" + this.rows + " " + this.region + '}';
        }
    }
}

