/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.uninverting;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.uninverting.DocTermOrds;
import org.apache.lucene.uninverting.FieldCache;
import org.apache.lucene.uninverting.FieldCacheSanityChecker;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

class FieldCacheImpl
implements FieldCache {
    private Map<Class<?>, Cache> caches;
    final LeafReader.CoreClosedListener purgeCore = new LeafReader.CoreClosedListener(){

        @Override
        public void onClose(Object ownerCoreCacheKey) {
            FieldCacheImpl.this.purgeByCacheKey(ownerCoreCacheKey);
        }
    };
    private volatile PrintStream infoStream;

    FieldCacheImpl() {
        this.init();
    }

    private synchronized void init() {
        this.caches = new HashMap(6);
        this.caches.put(Long.TYPE, new LongCache(this));
        this.caches.put(BinaryDocValues.class, new BinaryDocValuesCache(this));
        this.caches.put(SortedDocValues.class, new SortedDocValuesCache(this));
        this.caches.put(DocTermOrds.class, new DocTermOrdsCache(this));
        this.caches.put(DocsWithFieldCache.class, new DocsWithFieldCache(this));
    }

    @Override
    public synchronized void purgeAllCaches() {
        this.init();
    }

    @Override
    public synchronized void purgeByCacheKey(Object coreCacheKey) {
        for (Cache c : this.caches.values()) {
            c.purgeByCacheKey(coreCacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized FieldCache.CacheEntry[] getCacheEntries() {
        ArrayList<FieldCache.CacheEntry> result = new ArrayList<FieldCache.CacheEntry>(17);
        for (Map.Entry<Class<?>, Cache> cacheEntry : this.caches.entrySet()) {
            Cache cache = cacheEntry.getValue();
            Class<?> cacheType = cacheEntry.getKey();
            Map<Object, Map<CacheKey, Accountable>> map2 = cache.readerCache;
            synchronized (map2) {
                for (Map.Entry<Object, Map<CacheKey, Accountable>> readerCacheEntry : cache.readerCache.entrySet()) {
                    Object readerKey = readerCacheEntry.getKey();
                    if (readerKey == null) continue;
                    Map<CacheKey, Accountable> innerCache = readerCacheEntry.getValue();
                    for (Map.Entry<CacheKey, Accountable> mapEntry : innerCache.entrySet()) {
                        CacheKey entry = mapEntry.getKey();
                        result.add(new FieldCache.CacheEntry(readerKey, entry.field, cacheType, entry.custom, mapEntry.getValue()));
                    }
                }
            }
        }
        return result.toArray(new FieldCache.CacheEntry[result.size()]);
    }

    private void initReader(LeafReader reader2) {
        reader2.addCoreClosedListener(this.purgeCore);
    }

    void setDocsWithField(LeafReader reader2, String field, Bits docsWithField) {
        Bits bits;
        int maxDoc = reader2.maxDoc();
        if (docsWithField == null) {
            bits = new Bits.MatchNoBits(maxDoc);
        } else if (docsWithField instanceof FixedBitSet) {
            int numSet = ((FixedBitSet)docsWithField).cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                bits = new Bits.MatchAllBits(maxDoc);
            } else {
                bits = docsWithField;
            }
        } else {
            bits = docsWithField;
        }
        this.caches.get(DocsWithFieldCache.class).put(reader2, new CacheKey(field, null), new BitsEntry(bits));
    }

    @Override
    public Bits getDocsWithField(LeafReader reader2, String field) throws IOException {
        FieldInfo fieldInfo = reader2.getFieldInfos().fieldInfo(field);
        if (fieldInfo == null) {
            return new Bits.MatchNoBits(reader2.maxDoc());
        }
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE) {
            return reader2.getDocsWithField(field);
        }
        if (fieldInfo.getIndexOptions() == IndexOptions.NONE) {
            return new Bits.MatchNoBits(reader2.maxDoc());
        }
        BitsEntry bitsEntry = (BitsEntry)this.caches.get(DocsWithFieldCache.class).get(reader2, new CacheKey(field, null), false);
        return bitsEntry.bits;
    }

    @Override
    public NumericDocValues getNumerics(LeafReader reader2, String field, FieldCache.Parser parser, boolean setDocsWithField) throws IOException {
        if (parser == null) {
            throw new NullPointerException();
        }
        NumericDocValues valuesIn = reader2.getNumericDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info2 = reader2.getFieldInfos().fieldInfo(field);
        if (info2 == null) {
            return DocValues.emptyNumeric();
        }
        if (info2.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + (Object)((Object)info2.getDocValuesType()));
        }
        if (info2.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyNumeric();
        }
        return (NumericDocValues)this.caches.get(Long.TYPE).get(reader2, new CacheKey(field, parser), setDocsWithField);
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader2, String field) throws IOException {
        return this.getTermsIndex(reader2, field, 0.5f);
    }

    @Override
    public SortedDocValues getTermsIndex(LeafReader reader2, String field, float acceptableOverheadRatio) throws IOException {
        SortedDocValues valuesIn = reader2.getSortedDocValues(field);
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info2 = reader2.getFieldInfos().fieldInfo(field);
        if (info2 == null) {
            return DocValues.emptySorted();
        }
        if (info2.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + (Object)((Object)info2.getDocValuesType()));
        }
        if (info2.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySorted();
        }
        SortedDocValuesImpl impl2 = (SortedDocValuesImpl)this.caches.get(SortedDocValues.class).get(reader2, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)), false);
        return impl2.iterator();
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader2, String field, boolean setDocsWithField) throws IOException {
        return this.getTerms(reader2, field, setDocsWithField, 0.5f);
    }

    @Override
    public BinaryDocValues getTerms(LeafReader reader2, String field, boolean setDocsWithField, float acceptableOverheadRatio) throws IOException {
        BinaryDocValues valuesIn = reader2.getBinaryDocValues(field);
        if (valuesIn == null) {
            valuesIn = reader2.getSortedDocValues(field);
        }
        if (valuesIn != null) {
            return valuesIn;
        }
        FieldInfo info2 = reader2.getFieldInfos().fieldInfo(field);
        if (info2 == null) {
            return DocValues.emptyBinary();
        }
        if (info2.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + (Object)((Object)info2.getDocValuesType()));
        }
        if (info2.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptyBinary();
        }
        BinaryDocValuesImpl impl2 = (BinaryDocValuesImpl)this.caches.get(BinaryDocValues.class).get(reader2, new CacheKey(field, Float.valueOf(acceptableOverheadRatio)), setDocsWithField);
        return impl2.iterator();
    }

    @Override
    public SortedSetDocValues getDocTermOrds(LeafReader reader2, String field, BytesRef prefix) throws IOException {
        assert (prefix == null || prefix == INT32_TERM_PREFIX || prefix == INT64_TERM_PREFIX);
        SortedSetDocValues dv = reader2.getSortedSetDocValues(field);
        if (dv != null) {
            return dv;
        }
        SortedDocValues sdv = reader2.getSortedDocValues(field);
        if (sdv != null) {
            return DocValues.singleton(sdv);
        }
        FieldInfo info2 = reader2.getFieldInfos().fieldInfo(field);
        if (info2 == null) {
            return DocValues.emptySortedSet();
        }
        if (info2.getDocValuesType() != DocValuesType.NONE) {
            throw new IllegalStateException("Type mismatch: " + field + " was indexed as " + (Object)((Object)info2.getDocValuesType()));
        }
        if (info2.getIndexOptions() == IndexOptions.NONE) {
            return DocValues.emptySortedSet();
        }
        Terms terms = reader2.terms(field);
        if (terms == null) {
            return DocValues.emptySortedSet();
        }
        long numPostings = terms.getSumDocFreq();
        if (numPostings != -1L && numPostings == (long)terms.getDocCount()) {
            return DocValues.singleton(this.getTermsIndex(reader2, field));
        }
        DocTermOrds dto = (DocTermOrds)this.caches.get(DocTermOrds.class).get(reader2, new CacheKey(field, prefix), false);
        return dto.iterator(reader2);
    }

    @Override
    public void setInfoStream(PrintStream stream) {
        this.infoStream = stream;
    }

    @Override
    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    static final class DocTermOrdsCache
    extends Cache {
        DocTermOrdsCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            BytesRef prefix = (BytesRef)key2.custom;
            return new DocTermOrds(reader2, null, key2.field, prefix);
        }
    }

    static final class BinaryDocValuesCache
    extends Cache {
        BinaryDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            int startBPV;
            final int maxDoc = reader2.maxDoc();
            Terms terms = reader2.terms(key2.field);
            float acceptableOverheadRatio = ((Float)key2.custom).floatValue();
            int termCountHardLimit = maxDoc;
            PagedBytes bytes2 = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)termCountHardLimit) {
                        numUniqueTerms = termCountHardLimit;
                    }
                    startBPV = PackedInts.bitsRequired(numUniqueTerms * 4L);
                } else {
                    startBPV = 1;
                }
            } else {
                startBPV = 1;
            }
            GrowableWriter docToOffset = new GrowableWriter(startBPV, maxDoc, acceptableOverheadRatio);
            bytes2.copyUsingLengthPrefix(new BytesRef());
            if (terms != null) {
                BytesRef term;
                int termCount = 0;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while (termCount++ != termCountHardLimit && (term = termsEnum.next()) != null) {
                    int docID;
                    long pointer = bytes2.copyUsingLengthPrefix(term);
                    docs = termsEnum.postings(null, docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToOffset.set(docID, pointer);
                    }
                }
            }
            final PackedInts.Mutable offsetReader = docToOffset.getMutable();
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader2, key2.field, new Bits(){

                    @Override
                    public boolean get(int index2) {
                        return offsetReader.get(index2) != 0L;
                    }

                    @Override
                    public int length() {
                        return maxDoc;
                    }
                });
            }
            return new BinaryDocValuesImpl(bytes2.freeze(true), offsetReader);
        }
    }

    private static class BinaryDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedInts.Reader docToOffset;

        public BinaryDocValuesImpl(PagedBytes.Reader bytes2, PackedInts.Reader docToOffset) {
            this.bytes = bytes2;
            this.docToOffset = docToOffset;
        }

        public BinaryDocValues iterator() {
            final BytesRef term = new BytesRef();
            return new BinaryDocValues(){

                @Override
                public BytesRef get(int docID) {
                    int pointer = (int)BinaryDocValuesImpl.this.docToOffset.get(docID);
                    if (pointer == 0) {
                        term.length = 0;
                    } else {
                        BinaryDocValuesImpl.this.bytes.fill(term, pointer);
                    }
                    return term;
                }
            };
        }

        @Override
        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.docToOffset.ramBytesUsed() + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("term bytes", this.bytes));
            resources.add(Accountables.namedAccountable("addresses", this.docToOffset));
            return Collections.unmodifiableList(resources);
        }
    }

    static class SortedDocValuesCache
    extends Cache {
        SortedDocValuesCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            int startTermsBPV;
            int maxDoc = reader2.maxDoc();
            Terms terms = reader2.terms(key2.field);
            float acceptableOverheadRatio = ((Float)key2.custom).floatValue();
            PagedBytes bytes2 = new PagedBytes(15);
            if (terms != null) {
                long numUniqueTerms = terms.size();
                if (numUniqueTerms != -1L) {
                    if (numUniqueTerms > (long)maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key2.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    startTermsBPV = PackedInts.bitsRequired(numUniqueTerms);
                } else {
                    startTermsBPV = 1;
                }
            } else {
                startTermsBPV = 1;
            }
            PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder(0.0f);
            GrowableWriter docToTermOrd = new GrowableWriter(startTermsBPV, maxDoc, acceptableOverheadRatio);
            int termOrd = 0;
            if (terms != null) {
                BytesRef term;
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (termOrd >= maxDoc) {
                        throw new IllegalStateException("Type mismatch: " + key2.field + " was indexed with multiple values per document, use SORTED_SET instead");
                    }
                    termOrdToBytesOffset.add(bytes2.copyUsingLengthPrefix(term));
                    docs = termsEnum.postings(null, docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        docToTermOrd.set(docID, 1 + termOrd);
                    }
                    ++termOrd;
                }
            }
            return new SortedDocValuesImpl(bytes2.freeze(true), termOrdToBytesOffset.build(), docToTermOrd.getMutable(), termOrd);
        }
    }

    public static class SortedDocValuesImpl
    implements Accountable {
        private final PagedBytes.Reader bytes;
        private final PackedLongValues termOrdToBytesOffset;
        private final PackedInts.Reader docToTermOrd;
        private final int numOrd;

        public SortedDocValuesImpl(PagedBytes.Reader bytes2, PackedLongValues termOrdToBytesOffset, PackedInts.Reader docToTermOrd, int numOrd) {
            this.bytes = bytes2;
            this.docToTermOrd = docToTermOrd;
            this.termOrdToBytesOffset = termOrdToBytesOffset;
            this.numOrd = numOrd;
        }

        public SortedDocValues iterator() {
            final BytesRef term = new BytesRef();
            return new SortedDocValues(){

                @Override
                public int getValueCount() {
                    return SortedDocValuesImpl.this.numOrd;
                }

                @Override
                public int getOrd(int docID) {
                    return (int)SortedDocValuesImpl.this.docToTermOrd.get(docID) - 1;
                }

                @Override
                public BytesRef lookupOrd(int ord) {
                    if (ord < 0) {
                        throw new IllegalArgumentException("ord must be >=0 (got ord=" + ord + ")");
                    }
                    SortedDocValuesImpl.this.bytes.fill(term, SortedDocValuesImpl.this.termOrdToBytesOffset.get(ord));
                    return term;
                }
            };
        }

        @Override
        public long ramBytesUsed() {
            return this.bytes.ramBytesUsed() + this.termOrdToBytesOffset.ramBytesUsed() + this.docToTermOrd.ramBytesUsed() + (long)(3 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 4L;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.add(Accountables.namedAccountable("term bytes", this.bytes));
            resources.add(Accountables.namedAccountable("ord -> term", this.termOrdToBytesOffset));
            resources.add(Accountables.namedAccountable("doc -> ord", this.docToTermOrd));
            return Collections.unmodifiableList(resources);
        }
    }

    static final class LongCache
    extends Cache {
        LongCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected Accountable createValue(final LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            GrowableWriterAndMinValue values;
            final FieldCache.Parser parser = (FieldCache.Parser)key2.custom;
            final HoldsOneThing valuesRef = new HoldsOneThing();
            Uninvert u = new Uninvert(){
                private long minValue;
                private long currentValue;
                private GrowableWriter values;

                @Override
                public void visitTerm(BytesRef term) {
                    this.currentValue = parser.parseValue(term);
                    if (this.values == null) {
                        int startBitsPerValue;
                        if (this.currentValue < 0L) {
                            this.minValue = this.currentValue;
                            startBitsPerValue = this.minValue == Long.MIN_VALUE ? 64 : PackedInts.bitsRequired(-this.minValue);
                        } else {
                            this.minValue = 0L;
                            startBitsPerValue = PackedInts.bitsRequired(this.currentValue);
                        }
                        this.values = new GrowableWriter(startBitsPerValue, reader2.maxDoc(), 0.5f);
                        if (this.minValue != 0L) {
                            this.values.fill(0, this.values.size(), -this.minValue);
                        }
                        valuesRef.set(new GrowableWriterAndMinValue(this.values, this.minValue));
                    }
                }

                @Override
                public void visitDoc(int docID) {
                    this.values.set(docID, this.currentValue - this.minValue);
                }

                @Override
                protected TermsEnum termsEnum(Terms terms) throws IOException {
                    return parser.termsEnum(terms);
                }
            };
            u.uninvert(reader2, key2.field, setDocsWithField);
            if (setDocsWithField) {
                this.wrapper.setDocsWithField(reader2, key2.field, u.docsWithField);
            }
            if ((values = (GrowableWriterAndMinValue)valuesRef.get()) == null) {
                return new LongsFromArray(new PackedInts.NullReader(reader2.maxDoc()), 0L);
            }
            return new LongsFromArray(values.writer.getMutable(), values.minValue);
        }
    }

    static class LongsFromArray
    extends NumericDocValues
    implements Accountable {
        private final PackedInts.Reader values;
        private final long minValue;

        public LongsFromArray(PackedInts.Reader values, long minValue) {
            this.values = values;
            this.minValue = minValue;
        }

        @Override
        public long get(int docID) {
            return this.minValue + this.values.get(docID);
        }

        @Override
        public long ramBytesUsed() {
            return this.values.ramBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8L;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    static final class DocsWithFieldCache
    extends Cache {
        DocsWithFieldCache(FieldCacheImpl wrapper) {
            super(wrapper);
        }

        @Override
        protected BitsEntry createValue(LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            String field = key2.field;
            int maxDoc = reader2.maxDoc();
            FixedBitSet res = null;
            Terms terms = reader2.terms(field);
            if (terms != null) {
                BytesRef term;
                int termsDocCount = terms.getDocCount();
                assert (termsDocCount <= maxDoc);
                if (termsDocCount == maxDoc) {
                    return new BitsEntry(new Bits.MatchAllBits(maxDoc));
                }
                TermsEnum termsEnum = terms.iterator();
                PostingsEnum docs = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    if (res == null) {
                        res = new FixedBitSet(maxDoc);
                    }
                    docs = termsEnum.postings(null, docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        res.set(docID);
                    }
                }
            }
            if (res == null) {
                return new BitsEntry(new Bits.MatchNoBits(maxDoc));
            }
            int numSet = res.cardinality();
            if (numSet >= maxDoc) {
                assert (numSet == maxDoc);
                return new BitsEntry(new Bits.MatchAllBits(maxDoc));
            }
            return new BitsEntry(res);
        }
    }

    static class BitsEntry
    implements Accountable {
        final Bits bits;

        BitsEntry(Bits bits) {
            this.bits = bits;
        }

        @Override
        public long ramBytesUsed() {
            long base = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
            if (this.bits instanceof Bits.MatchAllBits || this.bits instanceof Bits.MatchNoBits) {
                return base;
            }
            return base + (long)(this.bits.length() >>> 3);
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }
    }

    private static class GrowableWriterAndMinValue {
        public GrowableWriter writer;
        public long minValue;

        GrowableWriterAndMinValue(GrowableWriter array2, long minValue) {
            this.writer = array2;
            this.minValue = minValue;
        }
    }

    private static class HoldsOneThing<T> {
        private T it;

        private HoldsOneThing() {
        }

        public void set(T it) {
            this.it = it;
        }

        public T get() {
            return this.it;
        }
    }

    private static abstract class Uninvert {
        public Bits docsWithField;

        private Uninvert() {
        }

        public void uninvert(LeafReader reader2, String field, boolean setDocsWithField) throws IOException {
            int maxDoc = reader2.maxDoc();
            Terms terms = reader2.terms(field);
            if (terms != null) {
                BytesRef term;
                if (setDocsWithField) {
                    int termsDocCount = terms.getDocCount();
                    assert (termsDocCount <= maxDoc);
                    if (termsDocCount == maxDoc) {
                        this.docsWithField = new Bits.MatchAllBits(maxDoc);
                        setDocsWithField = false;
                    }
                }
                TermsEnum termsEnum = this.termsEnum(terms);
                PostingsEnum docs = null;
                FixedBitSet docsWithField = null;
                while ((term = termsEnum.next()) != null) {
                    int docID;
                    this.visitTerm(term);
                    docs = termsEnum.postings(null, docs, 0);
                    while ((docID = docs.nextDoc()) != Integer.MAX_VALUE) {
                        this.visitDoc(docID);
                        if (!setDocsWithField) continue;
                        if (docsWithField == null) {
                            docsWithField = new FixedBitSet(maxDoc);
                            this.docsWithField = docsWithField;
                        }
                        docsWithField.set(docID);
                    }
                }
            }
        }

        protected abstract TermsEnum termsEnum(Terms var1) throws IOException;

        protected abstract void visitTerm(BytesRef var1);

        protected abstract void visitDoc(int var1);
    }

    static class CacheKey {
        final String field;
        final Object custom;

        CacheKey(String field, Object custom) {
            this.field = field;
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o instanceof CacheKey) {
                CacheKey other = (CacheKey)o;
                if (other.field.equals(this.field) && (other.custom == null ? this.custom == null : other.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.field.hashCode() ^ (this.custom == null ? 0 : this.custom.hashCode());
        }
    }

    static abstract class Cache {
        final FieldCacheImpl wrapper;
        final Map<Object, Map<CacheKey, Accountable>> readerCache = new WeakHashMap<Object, Map<CacheKey, Accountable>>();

        Cache(FieldCacheImpl wrapper) {
            this.wrapper = wrapper;
        }

        protected abstract Accountable createValue(LeafReader var1, CacheKey var2, boolean var3) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void purgeByCacheKey(Object coreCacheKey) {
            Map<Object, Map<CacheKey, Accountable>> map2 = this.readerCache;
            synchronized (map2) {
                this.readerCache.remove(coreCacheKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(LeafReader reader2, CacheKey key2, Accountable value) {
            Object readerKey = reader2.getCoreCacheKey();
            Map<Object, Map<CacheKey, Accountable>> map2 = this.readerCache;
            synchronized (map2) {
                Map<CacheKey, Accountable> innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader2);
                }
                if (innerCache.get(key2) == null) {
                    innerCache.put(key2, value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(LeafReader reader2, CacheKey key2, boolean setDocsWithField) throws IOException {
            Accountable value;
            Map<CacheKey, Accountable> innerCache;
            Object readerKey = reader2.getCoreCacheKey();
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = this.readerCache.get(readerKey);
                if (innerCache == null) {
                    innerCache = new HashMap<CacheKey, Accountable>();
                    this.readerCache.put(readerKey, innerCache);
                    this.wrapper.initReader(reader2);
                    value = null;
                } else {
                    value = innerCache.get(key2);
                }
                if (value == null) {
                    value = new FieldCache.CreationPlaceholder();
                    innerCache.put(key2, value);
                }
            }
            if (value instanceof FieldCache.CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    FieldCache.CreationPlaceholder progress = (FieldCache.CreationPlaceholder)value;
                    if (progress.value == null) {
                        PrintStream infoStream;
                        progress.value = this.createValue(reader2, key2, setDocsWithField);
                        Map<Object, Map<CacheKey, Accountable>> map2 = this.readerCache;
                        synchronized (map2) {
                            innerCache.put(key2, progress.value);
                        }
                        if (key2.custom != null && this.wrapper != null && (infoStream = this.wrapper.getInfoStream()) != null) {
                            this.printNewInsanity(infoStream, progress.value);
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        private void printNewInsanity(PrintStream infoStream, Object value) {
            FieldCacheSanityChecker.Insanity[] insanities = FieldCacheSanityChecker.checkSanity(this.wrapper);
            block0: for (int i = 0; i < insanities.length; ++i) {
                FieldCacheSanityChecker.Insanity insanity = insanities[i];
                FieldCache.CacheEntry[] entries = insanity.getCacheEntries();
                for (int j = 0; j < entries.length; ++j) {
                    if (entries[j].getValue() != value) continue;
                    infoStream.println("WARNING: new FieldCache insanity created\nDetails: " + insanity.toString());
                    infoStream.println("\nStack:\n");
                    new Throwable().printStackTrace(infoStream);
                    continue block0;
                }
            }
        }
    }
}

