/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.uninverting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.uninverting.FieldCache;
import org.apache.lucene.util.Bits;

public class UninvertingReader
extends FilterLeafReader {
    final Map<String, Type> mapping;
    final FieldInfos fieldInfos;

    public static DirectoryReader wrap(DirectoryReader in, Map<String, Type> mapping) throws IOException {
        return new UninvertingDirectoryReader(in, mapping);
    }

    public UninvertingReader(LeafReader in, Map<String, Type> mapping) {
        super(in);
        this.mapping = mapping;
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            Type t;
            DocValuesType type2 = fi.getDocValuesType();
            if (fi.getIndexOptions() != IndexOptions.NONE && fi.getDocValuesType() == DocValuesType.NONE && (t = mapping.get(fi.name)) != null) {
                switch (t) {
                    case INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        type2 = DocValuesType.NUMERIC;
                        break;
                    }
                    case BINARY: {
                        type2 = DocValuesType.BINARY;
                        break;
                    }
                    case SORTED: {
                        type2 = DocValuesType.SORTED;
                        break;
                    }
                    case SORTED_SET_BINARY: 
                    case SORTED_SET_INTEGER: 
                    case SORTED_SET_FLOAT: 
                    case SORTED_SET_LONG: 
                    case SORTED_SET_DOUBLE: {
                        type2 = DocValuesType.SORTED_SET;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            filteredInfos.add(new FieldInfo(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), type2, -1L, Collections.emptyMap()));
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
    }

    @Override
    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    @Override
    public NumericDocValues getNumericDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case INTEGER: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.NUMERIC_UTILS_INT_PARSER, true);
                }
                case FLOAT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.NUMERIC_UTILS_FLOAT_PARSER, true);
                }
                case LONG: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.NUMERIC_UTILS_LONG_PARSER, true);
                }
                case DOUBLE: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, true);
                }
            }
        }
        return super.getNumericDocValues(field);
    }

    @Override
    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v == Type.BINARY) {
            return FieldCache.DEFAULT.getTerms(this.in, field, true);
        }
        return this.in.getBinaryDocValues(field);
    }

    @Override
    public SortedDocValues getSortedDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v == Type.SORTED) {
            return FieldCache.DEFAULT.getTermsIndex(this.in, field);
        }
        return this.in.getSortedDocValues(field);
    }

    @Override
    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case SORTED_SET_INTEGER: 
                case SORTED_SET_FLOAT: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT32_TERM_PREFIX);
                }
                case SORTED_SET_LONG: 
                case SORTED_SET_DOUBLE: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT64_TERM_PREFIX);
                }
                case SORTED_SET_BINARY: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, null);
                }
            }
        }
        return this.in.getSortedSetDocValues(field);
    }

    @Override
    public Bits getDocsWithField(String field) throws IOException {
        if (this.getType(field) != null) {
            return FieldCache.DEFAULT.getDocsWithField(this.in, field);
        }
        return this.in.getDocsWithField(field);
    }

    private Type getType(String field) {
        FieldInfo info2 = this.fieldInfos.fieldInfo(field);
        if (info2 == null || info2.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        return this.mapping.get(field);
    }

    @Override
    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    @Override
    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    @Override
    public String toString() {
        return "Uninverting(" + this.in.toString() + ")";
    }

    public static String[] getUninvertedStats() {
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        String[] info2 = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            info2[i] = entries[i].toString();
        }
        return info2;
    }

    static class UninvertingDirectoryReader
    extends FilterDirectoryReader {
        final Map<String, Type> mapping;

        public UninvertingDirectoryReader(DirectoryReader in, final Map<String, Type> mapping) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                @Override
                public LeafReader wrap(LeafReader reader2) {
                    return new UninvertingReader(reader2, mapping);
                }
            });
            this.mapping = mapping;
        }

        @Override
        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new UninvertingDirectoryReader(in, this.mapping);
        }
    }

    public static enum Type {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BINARY,
        SORTED,
        SORTED_SET_BINARY,
        SORTED_SET_INTEGER,
        SORTED_SET_FLOAT,
        SORTED_SET_LONG,
        SORTED_SET_DOUBLE;

    }
}

