/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.RamUsageEstimator;

public final class BytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4);
        this.bytesUsed = bytesUsed;
    }

    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    public int append(BytesRef bytes2) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((this.offsets.length - oldLen) * 4);
        }
        this.pool.append(bytes2);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes2.length;
        return this.lastElement - 1;
    }

    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRefBuilder spare, int index2) {
        if (this.lastElement > index2) {
            int offset = this.offsets[index2];
            int length = index2 == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index2 + 1] - offset;
            spare.grow(length);
            spare.setLength(length);
            this.pool.readBytes(offset, spare.bytes(), 0, spare.length());
            return spare.get();
        }
        throw new IndexOutOfBoundsException("index " + index2 + " must be less than the size: " + this.lastElement);
    }

    private int[] sort(final Comparator<BytesRef> comp2) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new IntroSorter(){
            private BytesRef pivot;
            private final BytesRefBuilder pivotBuilder = new BytesRefBuilder();
            private final BytesRefBuilder scratch1 = new BytesRefBuilder();
            private final BytesRefBuilder scratch2 = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            @Override
            protected int compare(int i, int j) {
                int idx1 = orderedEntries[i];
                int idx2 = orderedEntries[j];
                return comp2.compare(BytesRefArray.this.get(this.scratch1, idx1), BytesRefArray.this.get(this.scratch2, idx2));
            }

            @Override
            protected void setPivot(int i) {
                int index2 = orderedEntries[i];
                this.pivot = BytesRefArray.this.get(this.pivotBuilder, index2);
            }

            @Override
            protected int comparePivot(int j) {
                int index2 = orderedEntries[j];
                return comp2.compare(this.pivot, BytesRefArray.this.get(this.scratch2, index2));
            }
        }.sort(0, this.size());
        return orderedEntries;
    }

    public BytesRefIterator iterator() {
        return this.iterator(null);
    }

    public BytesRefIterator iterator(Comparator<BytesRef> comp2) {
        final BytesRefBuilder spare = new BytesRefBuilder();
        final int size = this.size();
        final int[] indices = comp2 == null ? null : this.sort(comp2);
        return new BytesRefIterator(){
            int pos = 0;

            @Override
            public BytesRef next() {
                if (this.pos < size) {
                    int n;
                    if (indices == null) {
                        int n2 = this.pos;
                        n = n2;
                        this.pos = n2 + 1;
                    } else {
                        n = indices[this.pos++];
                    }
                    return BytesRefArray.this.get(spare, n);
                }
                return null;
            }
        };
    }
}

