/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.concurrent.locks;

import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.LockManager;
import org.eclipse.rdf4j.common.concurrent.locks.Properties;
import org.eclipse.rdf4j.common.concurrent.locks.ReadWriteLockManager;

public abstract class AbstractReadWriteLockManager
implements ReadWriteLockManager {
    private final LockManager activeWriter;
    private final LockManager activeReaders;

    public AbstractReadWriteLockManager() {
        this(false);
    }

    public AbstractReadWriteLockManager(boolean trackLocks) {
        boolean trace2 = trackLocks || Properties.lockTrackingEnabled();
        this.activeWriter = new LockManager(trace2);
        this.activeReaders = new LockManager(trace2);
    }

    protected boolean isWriterActive() {
        return this.activeWriter.isActiveLock();
    }

    protected boolean isReaderActive() {
        return this.activeReaders.isActiveLock();
    }

    protected void waitForActiveWriter() throws InterruptedException {
        this.activeWriter.waitForActiveLocks();
    }

    protected void waitForActiveReaders() throws InterruptedException {
        this.activeReaders.waitForActiveLocks();
    }

    protected Lock createReadLock() {
        return this.activeReaders.createLock("Read");
    }

    protected Lock createWriteLock() {
        return this.activeWriter.createLock("Write");
    }
}

