/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public final class NioFile
implements Closeable {
    private final File file;
    private final String mode;
    private volatile RandomAccessFile raf;
    private volatile FileChannel fc;
    private volatile boolean explictlyClosed;

    public NioFile(File file2) throws IOException {
        this(file2, "rw");
    }

    public NioFile(File file2, String mode) throws IOException {
        boolean created;
        this.file = file2;
        this.mode = mode;
        if (!file2.exists() && !(created = file2.createNewFile())) {
            throw new IOException("Failed to create file: " + file2);
        }
        this.explictlyClosed = false;
        this.open();
    }

    private void open() throws IOException {
        this.raf = new RandomAccessFile(this.file, this.mode);
        this.fc = this.raf.getChannel();
    }

    private synchronized void reopen(ClosedChannelException e2) throws IOException {
        if (this.explictlyClosed) {
            throw e2;
        }
        if (this.fc.isOpen()) {
            return;
        }
        this.open();
    }

    @Override
    public synchronized void close() throws IOException {
        this.explictlyClosed = true;
        this.raf.close();
    }

    public boolean isClosed() {
        return this.explictlyClosed;
    }

    public File getFile() {
        return this.file;
    }

    public boolean delete() throws IOException {
        try {
            boolean bl = this.file.delete();
            return bl;
        }
        finally {
            this.close();
        }
    }

    public void force(boolean metaData) throws IOException {
        while (true) {
            try {
                this.fc.force(metaData);
                return;
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public void truncate(long size) throws IOException {
        while (true) {
            try {
                this.fc.truncate(size);
                return;
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public long size() throws IOException {
        while (true) {
            try {
                return this.fc.size();
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public long transferTo(long position, long count2, WritableByteChannel target) throws IOException {
        while (true) {
            try {
                return this.fc.transferTo(position, count2, target);
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public int write(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.write(buf, offset);
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public int read(ByteBuffer buf, long offset) throws IOException {
        while (true) {
            try {
                return this.fc.read(buf, offset);
            }
            catch (ClosedByInterruptException e2) {
                throw e2;
            }
            catch (ClosedChannelException e3) {
                this.reopen(e3);
                continue;
            }
            break;
        }
    }

    public void writeBytes(byte[] value, long offset) throws IOException {
        this.write(ByteBuffer.wrap(value), offset);
    }

    public byte[] readBytes(long offset, int length) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(length);
        this.read(buf, offset);
        return buf.array();
    }

    public void writeByte(byte value, long offset) throws IOException {
        this.writeBytes(new byte[]{value}, offset);
    }

    public byte readByte(long offset) throws IOException {
        return this.readBytes(offset, 1)[0];
    }

    public void writeLong(long value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(0, value);
        this.write(buf, offset);
    }

    public long readLong(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        this.read(buf, offset);
        return buf.getLong(0);
    }

    public void writeInt(int value, long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(0, value);
        this.write(buf, offset);
    }

    public int readInt(long offset) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.read(buf, offset);
        return buf.getInt(0);
    }
}

