/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin;

import java.io.File;
import java.util.Properties;
import org.eclipse.rdf4j.lucene.spin.LuceneSpinSailConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.evaluation.TupleFunctionEvaluationMode;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;
import org.eclipse.rdf4j.sail.lucene.util.SearchIndexUtils;
import org.eclipse.rdf4j.sail.spin.SpinSail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSpinSail
extends NotifyingSailWrapper {
    private final Logger log = LoggerFactory.getLogger(LuceneSpinSail.class);
    private SearchIndex si;
    private Properties parameters = new Properties();

    public LuceneSpinSail() {
    }

    public LuceneSpinSail(NotifyingSail baseSail) {
        super(baseSail);
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public void setParameters(Properties parameters) {
        this.parameters = parameters;
    }

    @Override
    public void initialize() throws SailException {
        ((SpinSail)this.getBaseSail()).setEvaluationMode(TupleFunctionEvaluationMode.TRIPLE_SOURCE);
        this.parameters.setProperty("index", this.getParameters().getProperty("index", "org.eclipse.rdf4j.sail.lucene.LuceneIndex"));
        this.log.debug("index location: {}", (Object)this.parameters.getProperty("lucenedir"));
        try {
            this.si = SearchIndexUtils.createSearchIndex(this.parameters);
            ((SpinSail)this.getBaseSail()).addQueryContextInitializer(new SearchIndexQueryContextInitializer(this.si));
        }
        catch (Exception ex) {
            this.log.warn("error occured during set up of the search index. It might affect functionality.");
            throw new SailException(ex);
        }
        super.initialize();
    }

    @Override
    public void setDataDir(File dataDir) {
        this.parameters.setProperty("lucenedir", dataDir.getAbsolutePath() + "/index");
        this.getBaseSail().setDataDir(dataDir);
    }

    @Override
    public NotifyingSailConnection getConnection() throws SailException {
        NotifyingSailConnection connection = super.getConnection();
        if (this.si == null) {
            throw new SailException("Index is not created");
        }
        return new LuceneSpinSailConnection(connection, this.getValueFactory(), this.si);
    }
}

