/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;

public class ConjunctiveConstraintSplitter
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new ConstraintVisitor(tupleExpr));
    }

    protected static class ConstraintVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public ConstraintVisitor(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        @Override
        public void meet(Filter filter2) {
            super.meet(filter2);
            ArrayList<ValueExpr> conjunctiveConstraints = new ArrayList<ValueExpr>(16);
            this.getConjunctiveConstraints(filter2.getCondition(), conjunctiveConstraints);
            TupleExpr filterArg = filter2.getArg();
            for (int i = conjunctiveConstraints.size() - 1; i >= 1; --i) {
                Filter newFilter = new Filter(filterArg, (ValueExpr)conjunctiveConstraints.get(i));
                filterArg = newFilter;
            }
            filter2.setCondition((ValueExpr)conjunctiveConstraints.get(0));
            filter2.setArg(filterArg);
        }

        @Override
        public void meet(LeftJoin node2) {
            super.meet(node2);
            if (node2.getCondition() != null) {
                ArrayList<ValueExpr> conjunctiveConstraints = new ArrayList<ValueExpr>(16);
                this.getConjunctiveConstraints(node2.getCondition(), conjunctiveConstraints);
                TupleExpr arg = node2.getRightArg();
                ValueExpr condition = null;
                for (ValueExpr constraint : conjunctiveConstraints) {
                    if (this.isWithinBindingScope(constraint, arg)) {
                        arg = new Filter(arg, constraint);
                        continue;
                    }
                    if (condition == null) {
                        condition = constraint;
                        continue;
                    }
                    condition = new And(condition, constraint);
                }
                node2.setCondition(condition);
                node2.setRightArg(arg);
            }
        }

        protected void getConjunctiveConstraints(ValueExpr valueExpr, List<ValueExpr> conjunctiveConstraints) {
            if (valueExpr instanceof And) {
                And and2 = (And)valueExpr;
                this.getConjunctiveConstraints(and2.getLeftArg(), conjunctiveConstraints);
                this.getConjunctiveConstraints(and2.getRightArg(), conjunctiveConstraints);
            } else {
                conjunctiveConstraints.add(valueExpr);
            }
        }

        private boolean isWithinBindingScope(ValueExpr condition, TupleExpr node2) {
            return node2.getBindingNames().containsAll(VarNameCollector.process(condition));
        }
    }
}

