/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.IntersectIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeIntersectIteration
extends IntersectIteration<BindingSet, QueryEvaluationException> {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeIntersectIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg1, Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, AtomicLong used, long maxSize) {
        this(arg1, arg2, false, used, maxSize);
    }

    public LimitedSizeIntersectIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg1, Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, boolean distinct2, AtomicLong used, long maxSize) {
        super(arg1, arg2, distinct2);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    public Set<BindingSet> addSecondSet(Iteration<? extends BindingSet, ? extends QueryEvaluationException> arg2, Set<BindingSet> set2) throws QueryEvaluationException {
        LimitedSizeIteratorUtil.addAll(arg2, set2, this.used, this.maxSize);
        return set2;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            long size = this.clearIncludeSet();
            this.used.addAndGet(-size);
        }
    }
}

