/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.util;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public class RDFRemover
extends AbstractRDFHandler {
    private final RepositoryConnection con;
    private boolean enforceContext;
    private Resource context;

    public RDFRemover(RepositoryConnection con) {
        this.con = con;
        this.enforceContext = false;
    }

    public void enforceContext(Resource context) {
        this.context = context;
        this.enforceContext = true;
    }

    public boolean enforcesContext() {
        return this.enforceContext;
    }

    public Resource getContext() {
        return this.context;
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        try {
            if (this.enforceContext) {
                this.con.remove(st.getSubject(), st.getPredicate(), st.getObject(), this.context);
            } else {
                this.con.remove(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
        catch (RepositoryException e2) {
            throw new RDFHandlerException(e2);
        }
    }
}

