/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;

public class LongConcurrentHashMap<V>
extends LongMap<V>
implements Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected final long hashSalt = new Random().nextLong();
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment<V>[] segments;

    final Segment<V> segmentFor(int hash2) {
        return this.segments[hash2 >>> this.segmentShift & this.segmentMask];
    }

    public LongConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    public LongConcurrentHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, 16);
    }

    public LongConcurrentHashMap() {
        this(16, 0.75f, 16);
    }

    @Override
    public boolean isEmpty() {
        int i;
        Segment<V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        int mcsum = 0;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            mc[i] = segments[i].modCount;
            mcsum += mc[i];
        }
        if (mcsum != 0) {
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count == 0 && mc[i] == segments[i].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment<V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            sum = 0L;
            for (Segment<V> segment : segments) {
                segment.lock();
            }
            for (Segment<V> segment : segments) {
                sum += (long)segment.count;
            }
            for (Segment<V> segment : segments) {
                segment.unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public Iterator<V> valuesIterator() {
        return new ValueIterator();
    }

    @Override
    public LongMap.LongMapIterator<V> longMapIterator() {
        return new MapIterator();
    }

    @Override
    public V get(long key2) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).get(key2, hash2);
    }

    public boolean containsKey(long key2) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).containsKey(key2, hash2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Segment<V>[] segments = this.segments;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int mcsum = 0;
            for (int i = 0; i < segments.length; ++i) {
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
                if (!segments[i].containsValue(value)) continue;
                return true;
            }
            boolean cleanSweep = true;
            if (mcsum != 0) {
                for (int i = 0; i < segments.length; ++i) {
                    if (mc[i] == segments[i].modCount) continue;
                    cleanSweep = false;
                    break;
                }
            }
            if (!cleanSweep) continue;
            return false;
        }
        for (Segment<V> segment : segments) {
            segment.lock();
        }
        boolean found = false;
        try {
            for (Segment<V> segment : segments) {
                if (!segment.containsValue(value)) continue;
                found = true;
                break;
            }
        }
        finally {
            for (Segment<V> segment : segments) {
                segment.unlock();
            }
        }
        return found;
    }

    @Override
    public V put(long key2, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).put(key2, hash2, value, false);
    }

    public V putIfAbsent(long key2, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).put(key2, hash2, value, true);
    }

    @Override
    public V remove(long key2) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).remove(key2, hash2, null);
    }

    public boolean remove(long key2, Object value) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return value != null && this.segmentFor(hash2).remove(key2, hash2, value) != null;
    }

    public boolean replace(long key2, V oldValue, V newValue) {
        if (oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).replace(key2, hash2, oldValue, newValue);
    }

    public V replace(long key2, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        return this.segmentFor(hash2).replace(key2, hash2, value);
    }

    @Override
    public void clear() {
        for (Segment<V> segment : this.segments) {
            segment.clear();
        }
    }

    final class MapIterator
    extends HashIterator
    implements LongMap.LongMapIterator<V> {
        private long key;
        private V value;

        MapIterator() {
        }

        @Override
        public boolean moveToNext() {
            if (!this.hasNext()) {
                return false;
            }
            HashEntry next2 = this.nextEntry();
            this.key = next2.key;
            this.value = next2.value;
            return true;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<Long> {
        KeyIterator() {
        }

        @Override
        public Long next() {
            return super.nextEntry().key;
        }
    }

    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry<V>[] currentTable;
        HashEntry<V> nextEntry;
        HashEntry<V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = LongConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment seg = LongConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (seg.count == 0) continue;
                this.currentTable = seg.table;
                for (int j = this.currentTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.currentTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LongConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    static final class Segment<V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry<V>[] table;
        final float loadFactor;

        Segment(int initialCapacity, float lf) {
            super(false);
            this.loadFactor = lf;
            this.setTable(HashEntry.newArray(initialCapacity));
        }

        static <V> Segment<V>[] newArray(int i) {
            return new Segment[i];
        }

        void setTable(HashEntry<V>[] newTable) {
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            this.table = newTable;
        }

        HashEntry<V> getFirst(int hash2) {
            HashEntry<V>[] tab = this.table;
            return tab[hash2 & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<V> e2) {
            this.lock();
            try {
                Object v = e2.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        V get(long key2, int hash2) {
            if (this.count != 0) {
                HashEntry<V> e2 = this.getFirst(hash2);
                while (e2 != null) {
                    if (e2.hash == hash2 && key2 == e2.key) {
                        Object v = e2.value;
                        if (v != null) {
                            return v;
                        }
                        return this.readValueUnderLock(e2);
                    }
                    e2 = e2.next;
                }
            }
            return null;
        }

        boolean containsKey(long key2, int hash2) {
            if (this.count != 0) {
                HashEntry<V> e2 = this.getFirst(hash2);
                while (e2 != null) {
                    if (e2.hash == hash2 && key2 == e2.key) {
                        return true;
                    }
                    e2 = e2.next;
                }
            }
            return false;
        }

        boolean containsValue(Object value) {
            if (this.count != 0) {
                HashEntry<V>[] tab;
                HashEntry<V>[] arr$ = tab = this.table;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    HashEntry<V> aTab;
                    HashEntry<V> e2 = aTab = arr$[i$];
                    while (e2 != null) {
                        Object v = e2.value;
                        if (v == null) {
                            v = this.readValueUnderLock(e2);
                        }
                        if (value.equals(v)) {
                            return true;
                        }
                        e2 = e2.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(long key2, int hash2, V oldValue, V newValue) {
            this.lock();
            try {
                HashEntry<V> e2 = this.getFirst(hash2);
                while (e2 != null && (e2.hash != hash2 || key2 != e2.key)) {
                    e2 = e2.next;
                }
                boolean replaced = false;
                if (e2 != null && oldValue.equals(e2.value)) {
                    replaced = true;
                    e2.value = newValue;
                }
                boolean bl = replaced;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(long key2, int hash2, V newValue) {
            this.lock();
            try {
                HashEntry<V> e2 = this.getFirst(hash2);
                while (e2 != null && (e2.hash != hash2 || key2 != e2.key)) {
                    e2 = e2.next;
                }
                V oldValue = null;
                if (e2 != null) {
                    oldValue = e2.value;
                    e2.value = newValue;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(long key2, int hash2, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                V oldValue;
                HashEntry<V> first;
                int c = this.count;
                if (c++ > this.threshold) {
                    this.rehash();
                }
                HashEntry<V>[] tab = this.table;
                int index2 = hash2 & tab.length - 1;
                HashEntry<V> e2 = first = tab[index2];
                while (e2 != null && (e2.hash != hash2 || key2 != e2.key)) {
                    e2 = e2.next;
                }
                if (e2 != null) {
                    oldValue = e2.value;
                    if (!onlyIfAbsent) {
                        e2.value = value;
                    }
                } else {
                    oldValue = null;
                    ++this.modCount;
                    tab[index2] = new HashEntry<V>(key2, hash2, first, value);
                    this.count = c;
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry<V>[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return;
            }
            HashEntry<V>[] newTable = HashEntry.newArray(oldCapacity << 1);
            this.threshold = (int)((float)newTable.length * this.loadFactor);
            int sizeMask = newTable.length - 1;
            for (HashEntry<V> e2 : oldTable) {
                int k;
                if (e2 == null) continue;
                HashEntry next2 = e2.next;
                int idx = e2.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e2;
                    continue;
                }
                HashEntry<V> lastRun = e2;
                int lastIdx = idx;
                HashEntry last = next2;
                while (last != null) {
                    k = last.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last;
                    }
                    last = last.next;
                }
                newTable[lastIdx] = lastRun;
                HashEntry<V> p = e2;
                while (p != lastRun) {
                    k = p.hash & sizeMask;
                    HashEntry n = newTable[k];
                    newTable[k] = new HashEntry(p.key, p.hash, n, p.value);
                    p = p.next;
                }
            }
            this.table = newTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(long key2, int hash2, Object value) {
            this.lock();
            try {
                HashEntry<V> first;
                int c = this.count - 1;
                HashEntry<V>[] tab = this.table;
                int index2 = hash2 & tab.length - 1;
                HashEntry<V> e2 = first = tab[index2];
                while (e2 != null && (e2.hash != hash2 || key2 != e2.key)) {
                    e2 = e2.next;
                }
                V oldValue = null;
                if (e2 != null) {
                    Object v = e2.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e2.next;
                        HashEntry<V> p = first;
                        while (p != e2) {
                            newFirst = new HashEntry(p.key, p.hash, newFirst, p.value);
                            p = p.next;
                        }
                        tab[index2] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry<V>[] tab = this.table;
                    for (int i = 0; i < tab.length; ++i) {
                        tab[i] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class HashEntry<V> {
        final long key;
        final int hash;
        volatile V value;
        final HashEntry<V> next;

        HashEntry(long key2, int hash2, HashEntry<V> next2, V value) {
            this.key = key2;
            this.hash = hash2;
            this.next = next2;
            this.value = value;
        }

        static <V> HashEntry<V>[] newArray(int i) {
            return new HashEntry[i];
        }
    }
}

