/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.xml.sax.Attributes;

public class PropertyAction
extends Action {
    static final String RESOURCE_ATTRIBUTE = "resource";
    static String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    @Override
    public void begin(InterpretationContext ec, String localName, Attributes attributes) {
        if ("substitutionProperty".equals(localName)) {
            this.addWarn("[substitutionProperty] element has been deprecated. Please use the [property] element instead.");
        }
        String name2 = attributes.getValue("name");
        String value = attributes.getValue("value");
        String scopeStr = attributes.getValue("scope");
        ActionUtil.Scope scope = ActionUtil.stringToScope(scopeStr);
        if (this.checkFileAttributeSanity(attributes)) {
            String file2 = attributes.getValue("file");
            file2 = ec.subst(file2);
            try {
                FileInputStream istream = new FileInputStream(file2);
                this.loadAndSetProperties(ec, istream, scope);
            }
            catch (FileNotFoundException e2) {
                this.addError("Could not find properties file [" + file2 + "].");
            }
            catch (IOException e1) {
                this.addError("Could not read properties file [" + file2 + "].", e1);
            }
        } else if (this.checkResourceAttributeSanity(attributes)) {
            String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
            URL resourceURL = Loader.getResourceBySelfClassLoader(resource2 = ec.subst(resource2));
            if (resourceURL == null) {
                this.addError("Could not find resource [" + resource2 + "].");
            } else {
                try {
                    InputStream istream = resourceURL.openStream();
                    this.loadAndSetProperties(ec, istream, scope);
                }
                catch (IOException e3) {
                    this.addError("Could not read resource file [" + resource2 + "].", e3);
                }
            }
        } else if (this.checkValueNameAttributesSanity(attributes)) {
            value = RegularEscapeUtil.basicEscape(value);
            value = value.trim();
            value = ec.subst(value);
            ActionUtil.setProperty(ec, name2, value, scope);
        } else {
            this.addError(INVALID_ATTRIBUTES);
        }
    }

    void loadAndSetProperties(InterpretationContext ec, InputStream istream, ActionUtil.Scope scope) throws IOException {
        Properties props = new Properties();
        props.load(istream);
        istream.close();
        ActionUtil.setProperties(ec, props, scope);
    }

    boolean checkFileAttributeSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(file2) && OptionHelper.isEmpty(name2) && OptionHelper.isEmpty(value) && OptionHelper.isEmpty(resource2);
    }

    boolean checkResourceAttributeSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(resource2) && OptionHelper.isEmpty(name2) && OptionHelper.isEmpty(value) && OptionHelper.isEmpty(file2);
    }

    boolean checkValueNameAttributesSanity(Attributes attributes) {
        String file2 = attributes.getValue("file");
        String name2 = attributes.getValue("name");
        String value = attributes.getValue("value");
        String resource2 = attributes.getValue(RESOURCE_ATTRIBUTE);
        return !OptionHelper.isEmpty(name2) && !OptionHelper.isEmpty(value) && OptionHelper.isEmpty(file2) && OptionHelper.isEmpty(resource2);
    }

    @Override
    public void end(InterpretationContext ec, String name2) {
    }

    public void finish(InterpretationContext ec) {
    }
}

