/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.entity.mime.MinimalField;

public class Header
implements Iterable<MinimalField> {
    private final List<MinimalField> fields = new LinkedList<MinimalField>();
    private final Map<String, List<MinimalField>> fieldMap = new HashMap<String, List<MinimalField>>();

    public void addField(MinimalField field) {
        if (field == null) {
            return;
        }
        String key2 = field.getName().toLowerCase(Locale.ROOT);
        List<MinimalField> values = this.fieldMap.get(key2);
        if (values == null) {
            values = new LinkedList<MinimalField>();
            this.fieldMap.put(key2, values);
        }
        values.add(field);
        this.fields.add(field);
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public MinimalField getField(String name2) {
        if (name2 == null) {
            return null;
        }
        String key2 = name2.toLowerCase(Locale.ROOT);
        List<MinimalField> list = this.fieldMap.get(key2);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields(String name2) {
        if (name2 == null) {
            return null;
        }
        String key2 = name2.toLowerCase(Locale.ROOT);
        List<MinimalField> list = this.fieldMap.get(key2);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MinimalField>(list);
    }

    public int removeFields(String name2) {
        if (name2 == null) {
            return 0;
        }
        String key2 = name2.toLowerCase(Locale.ROOT);
        List<MinimalField> removed = this.fieldMap.remove(key2);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        this.fields.removeAll(removed);
        return removed.size();
    }

    public void setField(MinimalField field) {
        if (field == null) {
            return;
        }
        String key2 = field.getName().toLowerCase(Locale.ROOT);
        List<MinimalField> list = this.fieldMap.get(key2);
        if (list == null || list.isEmpty()) {
            this.addField(field);
            return;
        }
        list.clear();
        list.add(field);
        int firstOccurrence = -1;
        int index2 = 0;
        Iterator<MinimalField> it = this.fields.iterator();
        while (it.hasNext()) {
            MinimalField f = it.next();
            if (f.getName().equalsIgnoreCase(field.getName())) {
                it.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index2;
                }
            }
            ++index2;
        }
        this.fields.add(firstOccurrence, field);
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

