/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;

public abstract class StopwordAnalyzerBase
extends Analyzer {
    protected final CharArraySet stopwords;

    public CharArraySet getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(CharArraySet stopwords) {
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
    }

    protected StopwordAnalyzerBase() {
        this((CharArraySet)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(boolean ignoreCase, Class<? extends Analyzer> aClass, String resource2, String comment2) throws IOException {
        CharArraySet charArraySet;
        Reader reader2 = null;
        try {
            reader2 = IOUtils.getDecodingReader(aClass.getResourceAsStream(resource2), StandardCharsets.UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader2, comment2, new CharArraySet(16, ignoreCase));
        }
        catch (Throwable throwable) {
            IOUtils.close(reader2);
            throw throwable;
        }
        IOUtils.close(reader2);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(Path stopwords) throws IOException {
        CharArraySet charArraySet;
        BufferedReader reader2 = null;
        try {
            reader2 = Files.newBufferedReader(stopwords, StandardCharsets.UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader2);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader2);
            throw throwable;
        }
        IOUtils.close(reader2);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(Reader stopwords) throws IOException {
        CharArraySet charArraySet;
        try {
            charArraySet = WordlistLoader.getWordSet(stopwords);
        }
        catch (Throwable throwable) {
            IOUtils.close(stopwords);
            throw throwable;
        }
        IOUtils.close(stopwords);
        return charArraySet;
    }
}

