/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    ScoreDoc pqTop;

    public static TopScoreDocCollector create(int numHits) {
        return TopScoreDocCollector.create(numHits, null);
    }

    public static TopScoreDocCollector create(int numHits, ScoreDoc after) {
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (after == null) {
            return new SimpleTopScoreDocCollector(numHits);
        }
        return new PagingTopScoreDocCollector(numHits, after);
    }

    TopScoreDocCollector(int numHits) {
        super(new HitQueue(numHits, true));
        this.pqTop = (ScoreDoc)this.pq.top();
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        float maxScore = Float.NaN;
        if (start == 0) {
            maxScore = results[0].score;
        } else {
            for (int i = this.pq.size(); i > 1; --i) {
                this.pq.pop();
            }
            maxScore = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, results, maxScore);
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    private static class PagingTopScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int collectedHits;

        PagingTopScoreDocCollector(int numHits, ScoreDoc after) {
            super(numHits);
            this.after = after;
            this.collectedHits = 0;
        }

        @Override
        protected int topDocsSize() {
            return this.collectedHits < this.pq.size() ? this.collectedHits : this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
            return results == null ? new TopDocs(this.totalHits, new ScoreDoc[0], Float.NaN) : new TopDocs(this.totalHits, results);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            final int afterDoc = this.after.doc - context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int doc2) throws IOException {
                    float score = this.scorer.score();
                    assert (score != Float.NEGATIVE_INFINITY);
                    assert (!Float.isNaN(score));
                    ++PagingTopScoreDocCollector.this.totalHits;
                    if (score > ((PagingTopScoreDocCollector)PagingTopScoreDocCollector.this).after.score || score == ((PagingTopScoreDocCollector)PagingTopScoreDocCollector.this).after.score && doc2 <= afterDoc) {
                        return;
                    }
                    if (score <= PagingTopScoreDocCollector.this.pqTop.score) {
                        return;
                    }
                    PagingTopScoreDocCollector.this.collectedHits++;
                    PagingTopScoreDocCollector.this.pqTop.doc = doc2 + docBase;
                    PagingTopScoreDocCollector.this.pqTop.score = score;
                    PagingTopScoreDocCollector.this.pqTop = (ScoreDoc)PagingTopScoreDocCollector.this.pq.updateTop();
                }
            };
        }
    }

    private static class SimpleTopScoreDocCollector
    extends TopScoreDocCollector {
        SimpleTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            final int docBase = context.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int doc2) throws IOException {
                    float score = this.scorer.score();
                    assert (score != Float.NEGATIVE_INFINITY);
                    assert (!Float.isNaN(score));
                    ++SimpleTopScoreDocCollector.this.totalHits;
                    if (score <= SimpleTopScoreDocCollector.this.pqTop.score) {
                        return;
                    }
                    SimpleTopScoreDocCollector.this.pqTop.doc = doc2 + docBase;
                    SimpleTopScoreDocCollector.this.pqTop.score = score;
                    SimpleTopScoreDocCollector.this.pqTop = (ScoreDoc)SimpleTopScoreDocCollector.this.pq.updateTop();
                }
            };
        }
    }

    static abstract class ScorerLeafCollector
    implements LeafCollector {
        Scorer scorer;

        ScorerLeafCollector() {
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }
}

