/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.MutableBits;

public abstract class BitSet
implements MutableBits,
Accountable {
    public abstract void set(int var1);

    public abstract void clear(int var1, int var2);

    public abstract int cardinality();

    public int approximateCardinality() {
        return this.cardinality();
    }

    public abstract int prevSetBit(int var1);

    public abstract int nextSetBit(int var1);

    protected final void assertUnpositioned(DocIdSetIterator iter) {
        if (iter.docID() != -1) {
            throw new IllegalStateException("This operation only works with an unpositioned iterator, got current position = " + iter.docID());
        }
    }

    public void or(DocIdSetIterator iter) throws IOException {
        this.assertUnpositioned(iter);
        int doc2 = iter.nextDoc();
        while (doc2 != Integer.MAX_VALUE) {
            this.set(doc2);
            doc2 = iter.nextDoc();
        }
    }

    private void leapFrog(DocIdSetIterator iter, LeapFrogCallBack callback) throws IOException {
        int length = this.length();
        int bitSetDoc = -1;
        int disiDoc = iter.nextDoc();
        while (true) {
            assert (bitSetDoc <= disiDoc);
            if (disiDoc >= length) {
                callback.finish();
                return;
            }
            if (bitSetDoc < disiDoc) {
                bitSetDoc = this.nextSetBit(disiDoc);
            }
            if (bitSetDoc == disiDoc) {
                callback.onMatch(bitSetDoc);
                disiDoc = iter.nextDoc();
                continue;
            }
            disiDoc = iter.advance(bitSetDoc);
        }
    }

    @Deprecated
    public void and(DocIdSetIterator iter) throws IOException {
        this.assertUnpositioned(iter);
        this.leapFrog(iter, new LeapFrogCallBack(){
            int previous = -1;

            @Override
            public void onMatch(int doc2) {
                BitSet.this.clear(this.previous + 1, doc2);
                this.previous = doc2;
            }

            @Override
            public void finish() {
                if (this.previous + 1 < BitSet.this.length()) {
                    BitSet.this.clear(this.previous + 1, BitSet.this.length());
                }
            }
        });
    }

    @Deprecated
    public void andNot(DocIdSetIterator iter) throws IOException {
        this.assertUnpositioned(iter);
        this.leapFrog(iter, new LeapFrogCallBack(){

            @Override
            public void onMatch(int doc2) {
                BitSet.this.clear(doc2);
            }
        });
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static abstract class LeapFrogCallBack {
        private LeapFrogCallBack() {
        }

        abstract void onMatch(int var1);

        void finish() {
        }
    }
}

