/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryPrologLexer {
    private static final Token HASH_TOKEN = new Token(TokenType.HASH, "#");
    private static final Token PREFIX_KEYWORD_TOKEN = new Token(TokenType.PREFIX_KEYWORD, "PREFIX");
    private static final Token BASE_KEYWORD_TOKEN = new Token(TokenType.BASE_KEYWORD, "BASE");
    private static final Token LBRACKET_TOKEN = new Token(TokenType.LBRACKET, "<");
    private static final Token RBRACKET_TOKEN = new Token(TokenType.RBRACKET, ">");
    private static final Pattern IRI_PATTERN = Pattern.compile("^<([^>]*)>*");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^prefix([^:]+):", 2);
    private static final Pattern COMMENT_PATTERN = Pattern.compile("^(#.*((\r)?\n|(\r)?\n*))*");

    public static List<Token> lex(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 0;
        block6: while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '#': {
                    result.add(HASH_TOKEN);
                    String comment2 = QueryPrologLexer.readComment(input, i);
                    i += comment2.length() + 1;
                    result.add(new Token(TokenType.COMMENT, comment2));
                    continue block6;
                }
                case 'P': 
                case 'p': {
                    result.add(PREFIX_KEYWORD_TOKEN);
                    String prefix = QueryPrologLexer.readPrefix(input, i);
                    result.add(new Token(TokenType.PREFIX, prefix.trim()));
                    i = i + prefix.length() + 7;
                    continue block6;
                }
                case 'B': 
                case 'b': {
                    result.add(BASE_KEYWORD_TOKEN);
                    i += 4;
                    continue block6;
                }
                case '<': {
                    result.add(LBRACKET_TOKEN);
                    String iri = QueryPrologLexer.readIRI(input, i);
                    result.add(new Token(TokenType.IRI, iri));
                    result.add(RBRACKET_TOKEN);
                    i += iri.length() + 2;
                    continue block6;
                }
            }
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            String restOfQuery = input.substring(i);
            result.add(new Token(TokenType.REST_OF_QUERY, restOfQuery));
            i += restOfQuery.length();
        }
        return result;
    }

    public static Token getRestOfQueryToken(String input) {
        Token result = null;
        int i = 0;
        block6: while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '#': {
                    String comment2 = QueryPrologLexer.readComment(input, i);
                    i += comment2.length() + 1;
                    continue block6;
                }
                case 'P': 
                case 'p': {
                    String prefix = QueryPrologLexer.readPrefix(input, i);
                    i = i + prefix.length() + 7;
                    continue block6;
                }
                case 'B': 
                case 'b': {
                    i += 4;
                    continue block6;
                }
                case '<': {
                    String iri = QueryPrologLexer.readIRI(input, i);
                    i += iri.length() + 2;
                    continue block6;
                }
            }
            if (Character.isWhitespace(c)) {
                ++i;
                continue;
            }
            String restOfQuery = input.substring(i);
            result = new Token(TokenType.REST_OF_QUERY, restOfQuery);
            i += restOfQuery.length();
        }
        return result;
    }

    private static String readComment(String input, int index2) {
        String comment2 = null;
        Matcher matcher = COMMENT_PATTERN.matcher(input.substring(index2));
        if (matcher.find()) {
            comment2 = matcher.group(1);
            comment2 = comment2.substring(1);
        }
        return comment2;
    }

    private static String readPrefix(String input, int index2) {
        String prefix = null;
        Matcher matcher = PREFIX_PATTERN.matcher(input.substring(index2));
        if (matcher.find()) {
            prefix = matcher.group(1);
        }
        return prefix;
    }

    private static String readIRI(String input, int index2) {
        String iri = null;
        Matcher matcher = IRI_PATTERN.matcher(input.substring(index2));
        if (matcher.find()) {
            iri = matcher.group(1);
        }
        return iri;
    }

    public static class Token {
        public final TokenType t;
        public final String s;

        public Token(TokenType t, String s) {
            this.t = t;
            this.s = s;
        }

        public TokenType getType() {
            return this.t;
        }

        public String getStringValue() {
            return this.s;
        }

        public String toString() {
            return "[" + this.t.toString() + "] '" + this.s + "'";
        }
    }

    public static enum TokenType {
        PREFIX_KEYWORD,
        PREFIX,
        BASE_KEYWORD,
        LBRACKET,
        RBRACKET,
        IRI,
        HASH,
        COMMENT,
        REST_OF_QUERY;

    }
}

