/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.SessionManagerDependent;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryReadOnlyException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailBooleanQuery;
import org.eclipse.rdf4j.repository.sail.SailCloseableIteration;
import org.eclipse.rdf4j.repository.sail.SailGraphQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailUpdate;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolver;
import org.eclipse.rdf4j.repository.sail.config.RepositoryResolverClient;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;

public class SailRepositoryConnection
extends AbstractRepositoryConnection
implements FederatedServiceResolverClient,
RepositoryResolverClient,
HttpClientDependent,
SessionManagerDependent {
    private final SailConnection sailConnection;

    protected SailRepositoryConnection(SailRepository repository2, SailConnection sailConnection) {
        super(repository2);
        this.sailConnection = sailConnection;
    }

    public SailConnection getSailConnection() {
        return this.sailConnection;
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        if (this.sailConnection instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)this.sailConnection)).setFederatedServiceResolver(resolver);
        }
    }

    @Override
    public void setRepositoryResolver(RepositoryResolver resolver) {
        if (this.sailConnection instanceof RepositoryResolverClient) {
            ((RepositoryResolverClient)((Object)this.sailConnection)).setRepositoryResolver(resolver);
        }
    }

    @Override
    public HttpClientSessionManager getHttpClientSessionManager() {
        if (this.sailConnection instanceof SessionManagerDependent) {
            return ((SessionManagerDependent)((Object)this.sailConnection)).getHttpClientSessionManager();
        }
        return null;
    }

    @Override
    public void setHttpClientSessionManager(HttpClientSessionManager client) {
        if (this.sailConnection instanceof SessionManagerDependent) {
            ((SessionManagerDependent)((Object)this.sailConnection)).setHttpClientSessionManager(client);
        }
    }

    @Override
    public HttpClient getHttpClient() {
        if (this.sailConnection instanceof HttpClientDependent) {
            return ((HttpClientDependent)((Object)this.sailConnection)).getHttpClient();
        }
        return null;
    }

    @Override
    public void setHttpClient(HttpClient client) {
        if (this.sailConnection instanceof HttpClientDependent) {
            ((HttpClientDependent)((Object)this.sailConnection)).setHttpClient(client);
        }
    }

    @Override
    public void begin() throws RepositoryException {
        try {
            this.sailConnection.begin(this.getIsolationLevel());
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    public void begin(IsolationLevel level) throws RepositoryException {
        try {
            this.sailConnection.begin(level);
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    public void commit() throws RepositoryException {
        try {
            this.sailConnection.flush();
            this.sailConnection.prepare();
            this.sailConnection.commit();
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        try {
            this.sailConnection.rollback();
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    public void close() throws RepositoryException {
        try {
            super.close();
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
        finally {
            this.sailConnection.close();
        }
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        try {
            return this.sailConnection.isOpen();
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    public SailQuery prepareQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedQuery parsedQuery = QueryParserUtil.parseQuery(ql, queryString, baseURI);
        if (parsedQuery instanceof ParsedTupleQuery) {
            return new SailTupleQuery((ParsedTupleQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedGraphQuery) {
            return new SailGraphQuery((ParsedGraphQuery)parsedQuery, this);
        }
        if (parsedQuery instanceof ParsedBooleanQuery) {
            return new SailBooleanQuery((ParsedBooleanQuery)parsedQuery, this);
        }
        throw new RuntimeException("Unexpected query type: " + parsedQuery.getClass());
    }

    @Override
    public SailTupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedTupleQuery parsedQuery = QueryParserUtil.parseTupleQuery(ql, queryString, baseURI);
        return new SailTupleQuery(parsedQuery, this);
    }

    @Override
    public SailGraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedGraphQuery parsedQuery = QueryParserUtil.parseGraphQuery(ql, queryString, baseURI);
        return new SailGraphQuery(parsedQuery, this);
    }

    @Override
    public SailBooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseURI) throws MalformedQueryException {
        ParsedBooleanQuery parsedQuery = QueryParserUtil.parseBooleanQuery(ql, queryString, baseURI);
        return new SailBooleanQuery(parsedQuery, this);
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update2, String baseURI) throws RepositoryException, MalformedQueryException {
        ParsedUpdate parsedUpdate = QueryParserUtil.parseUpdate(ql, update2, baseURI);
        return new SailUpdate(parsedUpdate, this);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.sailConnection.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getContextIDs());
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to get context IDs from Sail", e2);
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        try {
            return this.createRepositoryResult(this.sailConnection.getStatements(subj, pred, obj, includeInferred, contexts));
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to get statements from Sail", e2);
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return !this.hasStatement(null, null, null, false, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        handler.startRDF();
        try (RepositoryResult<Namespace> nsIter = this.getNamespaces();){
            while (nsIter.hasNext()) {
                Namespace ns2 = (Namespace)nsIter.next();
                handler.handleNamespace(ns2.getPrefix(), ns2.getName());
            }
        }
        try (RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);){
            while (stIter.hasNext()) {
                handler.handleStatement((Statement)stIter.next());
            }
        }
        handler.endRDF();
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        try {
            return this.sailConnection.size(contexts);
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    @Override
    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            this.sailConnection.addStatement(subject, predicate, object, contexts);
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        try {
            if (subject == null && predicate == null && object == null) {
                this.sailConnection.clear(contexts);
            } else {
                this.sailConnection.removeStatements(subject, predicate, object, contexts);
            }
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        OpenRDFUtil.verifyContextNotNull(contexts);
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.clear(contexts);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public void setNamespace(String prefix, String name2) throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.setNamespace(prefix, name2);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.removeNamespace(prefix);
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        try {
            boolean local = this.startLocalTransaction();
            this.sailConnection.clearNamespaces();
            this.conditionalCommit(local);
        }
        catch (SailReadOnlyException e2) {
            throw new RepositoryReadOnlyException(e2.getMessage(), e2);
        }
        catch (SailException e3) {
            throw new RepositoryException(e3);
        }
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        try {
            return this.createRepositoryResult(this.sailConnection.getNamespaces());
        }
        catch (SailException e2) {
            throw new RepositoryException("Unable to get namespaces from Sail", e2);
        }
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        try {
            return this.sailConnection.getNamespace(prefix);
        }
        catch (SailException e2) {
            throw new RepositoryException(e2);
        }
    }

    protected <E> RepositoryResult<E> createRepositoryResult(CloseableIteration<? extends E, SailException> sailIter) {
        return new RepositoryResult(new SailCloseableIteration<E>(sailIter));
    }

    @Override
    public boolean isActive() throws UnknownTransactionStateException {
        try {
            return this.sailConnection.isActive();
        }
        catch (SailException e2) {
            throw new UnknownTransactionStateException(e2);
        }
    }

    public String toString() {
        return this.getSailConnection().toString();
    }
}

