/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sail;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.IteratingTupleQueryResult;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.repository.sail.SailQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;

public class SailTupleQuery
extends SailQuery
implements TupleQuery {
    protected SailTupleQuery(ParsedTupleQuery tupleQuery, SailRepositoryConnection sailConnection) {
        super(tupleQuery, sailConnection);
    }

    @Override
    public ParsedTupleQuery getParsedQuery() {
        return (ParsedTupleQuery)super.getParsedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter1 = null;
        CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter2 = null;
        AbstractCloseableIteration result = null;
        boolean allGood = false;
        try {
            SailConnection sailCon = this.getConnection().getSailConnection();
            bindingsIter1 = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter2 = this.enforceMaxQueryTime(bindingsIter1);
            result = new IteratingTupleQueryResult(new ArrayList<String>(tupleExpr.getBindingNames()), bindingsIter2);
            allGood = true;
            AbstractCloseableIteration abstractCloseableIteration = result;
            return abstractCloseableIteration;
        }
        catch (SailException e2) {
            throw new QueryEvaluationException(e2.getMessage(), e2);
        }
        finally {
            if (!allGood) {
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    try {
                        if (bindingsIter2 != null) {
                            bindingsIter2.close();
                        }
                    }
                    finally {
                        if (bindingsIter1 != null) {
                            bindingsIter1.close();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report(queryResult, handler);
    }
}

