/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.mapdb.Atomic;
import org.mapdb.Fun;

public final class Bind {
    private Bind() {
    }

    public static <K, V> void size(MapWithModificationListener<K, V> map2, final Atomic.Long sizeCounter) {
        if (sizeCounter.get() == 0L) {
            long size = map2.sizeLong();
            if (sizeCounter.get() != size) {
                sizeCounter.set(size);
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                if (oldVal == null && newVal != null) {
                    sizeCounter.incrementAndGet();
                } else if (oldVal != null && newVal == null) {
                    sizeCounter.decrementAndGet();
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValue(MapWithModificationListener<K, V> map2, final Map<K, V2> secondary, final Fun.Function2<V2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e2 : map2.entrySet()) {
                secondary.put(e2.getKey(), fun.run(e2.getKey(), e2.getValue()));
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(key2);
                } else {
                    secondary.put(key2, fun.run(key2, newVal));
                }
            }
        });
    }

    public static <K, V, V2> void secondaryValues(MapWithModificationListener<K, V> map2, final Set<Fun.Tuple2<K, V2>> secondary, final Fun.Function2<V2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e2 : map2.entrySet()) {
                V2[] v = fun.run(e2.getKey(), e2.getValue());
                if (v == null) continue;
                for (V2 v2 : v) {
                    secondary.add(Fun.t2(e2.getKey(), v2));
                }
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                block11: {
                    block12: {
                        block10: {
                            if (newVal != null) break block10;
                            Object[] v = (Object[])fun.run(key2, oldVal);
                            if (v == null) break block11;
                            for (Object v2 : v) {
                                secondary.remove(Fun.t2(key2, v2));
                            }
                            break block11;
                        }
                        if (oldVal != null) break block12;
                        Object[] v = (Object[])fun.run(key2, newVal);
                        if (v == null) break block11;
                        for (Object v2 : v) {
                            secondary.add(Fun.t2(key2, v2));
                        }
                        break block11;
                    }
                    Object[] oldv = (Object[])fun.run(key2, oldVal);
                    Object[] newv = (Object[])fun.run(key2, newVal);
                    if (oldv == null) {
                        if (newv != null) {
                            for (Object v : newv) {
                                secondary.add(Fun.t2(key2, v));
                            }
                        }
                        return;
                    }
                    if (newv == null) {
                        for (Object v : oldv) {
                            secondary.remove(Fun.t2(key2, v));
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldv);
                    for (Object v : newv) {
                        if (hashes.contains(v)) continue;
                        secondary.add(Fun.t2(key2, v));
                    }
                    for (Object v : newv) {
                        hashes.remove(v);
                    }
                    for (Object v : hashes) {
                        secondary.remove(Fun.t2(key2, v));
                    }
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map2, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e2 : map2.entrySet()) {
                secondary.add(Fun.t2(fun.run(e2.getKey(), e2.getValue()), e2.getKey()));
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(Fun.t2(fun.run(key2, oldVal), key2));
                } else if (oldVal == null) {
                    secondary.add(Fun.t2(fun.run(key2, newVal), key2));
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key2, oldVal);
                    if (oldKey == (newKey = fun.run(key2, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(Fun.t2(oldKey, key2));
                    secondary.add(Fun.t2(newKey, key2));
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKey(MapWithModificationListener<K, V> map2, final Map<K2, K> secondary, final Fun.Function2<K2, K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e2 : map2.entrySet()) {
                secondary.put(fun.run(e2.getKey(), e2.getValue()), e2.getKey());
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                if (newVal == null) {
                    secondary.remove(fun.run(key2, oldVal));
                } else if (oldVal == null) {
                    secondary.put(fun.run(key2, newVal), key2);
                } else {
                    Object newKey;
                    Object oldKey = fun.run(key2, oldVal);
                    if (oldKey == (newKey = fun.run(key2, newVal)) || oldKey.equals(newKey)) {
                        return;
                    }
                    secondary.remove(oldKey);
                    secondary.put(newKey, key2);
                }
            }
        });
    }

    public static <K, V, K2> void secondaryKeys(MapWithModificationListener<K, V> map2, final Set<Fun.Tuple2<K2, K>> secondary, final Fun.Function2<K2[], K, V> fun) {
        if (secondary.isEmpty()) {
            for (Map.Entry e2 : map2.entrySet()) {
                K2[] k2 = fun.run(e2.getKey(), e2.getValue());
                if (k2 == null) continue;
                for (K2 k22 : k2) {
                    secondary.add(Fun.t2(k22, e2.getKey()));
                }
            }
        }
        map2.modificationListenerAdd(new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                block11: {
                    block12: {
                        block10: {
                            if (newVal != null) break block10;
                            Object[] k2 = (Object[])fun.run(key2, oldVal);
                            if (k2 == null) break block11;
                            for (Object k22 : k2) {
                                secondary.remove(Fun.t2(k22, key2));
                            }
                            break block11;
                        }
                        if (oldVal != null) break block12;
                        Object[] k2 = (Object[])fun.run(key2, newVal);
                        if (k2 == null) break block11;
                        for (Object k22 : k2) {
                            secondary.add(Fun.t2(k22, key2));
                        }
                        break block11;
                    }
                    Object[] oldk = (Object[])fun.run(key2, oldVal);
                    Object[] newk = (Object[])fun.run(key2, newVal);
                    if (oldk == null) {
                        if (newk != null) {
                            for (Object k22 : newk) {
                                secondary.add(Fun.t2(k22, key2));
                            }
                        }
                        return;
                    }
                    if (newk == null) {
                        for (Object k22 : oldk) {
                            secondary.remove(Fun.t2(k22, key2));
                        }
                        return;
                    }
                    HashSet hashes = new HashSet();
                    Collections.addAll(hashes, oldk);
                    for (Object k2 : newk) {
                        if (hashes.contains(k2)) continue;
                        secondary.add(Fun.t2(k2, key2));
                    }
                    for (Object k2 : newk) {
                        hashes.remove(k2);
                    }
                    for (Object k2 : hashes) {
                        secondary.remove(Fun.t2(k2, key2));
                    }
                }
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Set<Fun.Tuple2<V, K>> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key2, V value) {
                return value;
            }
        });
    }

    public static <K, V> void mapInverse(MapWithModificationListener<K, V> primary, Map<V, K> inverse) {
        Bind.secondaryKey(primary, inverse, new Fun.Function2<V, K, V>(){

            @Override
            public V run(K key2, V value) {
                return value;
            }
        });
    }

    public static <K, V, C> void histogram(MapWithModificationListener<K, V> primary, final ConcurrentMap<C, Long> histogram, final Fun.Function2<C, K, V> entryToCategory) {
        MapListener listener = new MapListener<K, V>(){

            @Override
            public void update(K key2, V oldVal, V newVal) {
                if (newVal == null) {
                    Object category = entryToCategory.run(key2, oldVal);
                    this.incrementHistogram(category, -1L);
                } else if (oldVal == null) {
                    Object category = entryToCategory.run(key2, newVal);
                    this.incrementHistogram(category, 1L);
                } else {
                    Object newCat;
                    Object oldCat = entryToCategory.run(key2, oldVal);
                    if (oldCat == (newCat = entryToCategory.run(key2, newVal)) || oldCat.equals(newCat)) {
                        return;
                    }
                    this.incrementHistogram(oldCat, -1L);
                    this.incrementHistogram(oldCat, 1L);
                }
            }

            private void incrementHistogram(C category, long i) {
                Long newCount;
                Long oldCount;
                while (!((oldCount = (Long)histogram.get(category)) == null ? histogram.putIfAbsent(category, i) == null : histogram.replace(category, oldCount, newCount = Long.valueOf(oldCount + i)))) {
                }
            }
        };
        primary.modificationListenerAdd(listener);
        if (histogram.isEmpty()) {
            for (Map.Entry e2 : primary.entrySet()) {
                listener.update(e2.getKey(), null, e2.getValue());
            }
        }
    }

    public static interface MapWithModificationListener<K, V>
    extends Map<K, V> {
        public void modificationListenerAdd(MapListener<K, V> var1);

        public void modificationListenerRemove(MapListener<K, V> var1);

        public long sizeLong();
    }

    public static interface MapListener<K, V> {
        public void update(K var1, V var2, V var3);
    }
}

