/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.BytesRef;

public class TypeAsPayloadTokenFilter
extends TokenFilter {
    private final PayloadAttribute payloadAtt = this.addAttribute(PayloadAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);

    public TypeAsPayloadTokenFilter(TokenStream input) {
        super(input);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String type2 = this.typeAtt.type();
            if (type2 != null && !type2.isEmpty()) {
                this.payloadAtt.setPayload(new BytesRef(type2));
            }
            return true;
        }
        return false;
    }
}

