/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

final class Lucene50CompoundReader
extends Directory {
    private final Directory directory;
    private final String segmentName;
    private final Map<String, FileEntry> entries;
    private final IndexInput handle;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene50CompoundReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        this.directory = directory;
        this.segmentName = si.name;
        String dataFileName = IndexFileNames.segmentFileName(this.segmentName, "", "cfs");
        String entriesFileName = IndexFileNames.segmentFileName(this.segmentName, "", "cfe");
        this.entries = this.readEntries(si.getId(), directory, entriesFileName);
        boolean success = false;
        this.handle = directory.openInput(dataFileName, context);
        try {
            CodecUtil.checkIndexHeader(this.handle, "Lucene50CompoundData", this.version, this.version, si.getId(), "");
            CodecUtil.retrieveChecksum(this.handle);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.handle);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FileEntry> readEntries(byte[] segmentID, Directory dir2, String entriesFileName) throws IOException {
        HashMap<String, FileEntry> mapping;
        block19: {
            mapping = null;
            try (ChecksumIndexInput entriesStream = dir2.openChecksumInput(entriesFileName, IOContext.READONCE);){
                Throwable priorE = null;
                try {
                    this.version = CodecUtil.checkIndexHeader(entriesStream, "Lucene50CompoundEntries", 0, 0, segmentID, "");
                    int numEntries = entriesStream.readVInt();
                    mapping = new HashMap<String, FileEntry>(numEntries);
                    for (int i = 0; i < numEntries; ++i) {
                        FileEntry fileEntry = new FileEntry();
                        String id = entriesStream.readString();
                        FileEntry previous = mapping.put(id, fileEntry);
                        if (previous != null) {
                            throw new CorruptIndexException("Duplicate cfs entry id=" + id + " in CFS ", entriesStream);
                        }
                        fileEntry.offset = entriesStream.readLong();
                        fileEntry.length = entriesStream.readLong();
                    }
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(entriesStream, priorE);
                    }
                }
                CodecUtil.checkFooter(entriesStream, priorE);
            }
        }
        return Collections.unmodifiableMap(mapping);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.handle);
    }

    @Override
    public IndexInput openInput(String name2, IOContext context) throws IOException {
        this.ensureOpen();
        String id = IndexFileNames.stripSegmentName(name2);
        FileEntry entry = this.entries.get(id);
        if (entry == null) {
            throw new FileNotFoundException("No sub-file with id " + id + " found (fileName=" + name2 + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(name2, entry.offset, entry.length);
    }

    @Override
    public String[] listAll() {
        this.ensureOpen();
        String[] res = this.entries.keySet().toArray(new String[this.entries.size()]);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.segmentName + res[i];
        }
        return res;
    }

    @Override
    public void deleteFile(String name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameFile(String from, String to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fileLength(String name2) throws IOException {
        this.ensureOpen();
        FileEntry e2 = this.entries.get(IndexFileNames.stripSegmentName(name2));
        if (e2 == null) {
            throw new FileNotFoundException(name2);
        }
        return e2.length;
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync(Collection<String> names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock makeLock(String name2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + this.directory + ")";
    }

    public static final class FileEntry {
        long offset;
        long length;
    }
}

