/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;

public class Lucene50SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir2, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir2.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Map<String, String> attributes;
                Set<String> files;
                Map<String, String> diagnostics;
                boolean isCompoundFile;
                int format2 = CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 1, segmentID, "");
                Version version2 = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input);
                }
                boolean bl = isCompoundFile = input.readByte() == 1;
                if (format2 >= 1) {
                    diagnostics = input.readMapOfStrings();
                    files = input.readSetOfStrings();
                    attributes = input.readMapOfStrings();
                } else {
                    diagnostics = Collections.unmodifiableMap(input.readStringStringMap());
                    files = Collections.unmodifiableSet(input.readStringSet());
                    attributes = Collections.unmodifiableMap(input.readStringStringMap());
                }
                si = new SegmentInfo(dir2, version2, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes);
                si.setFiles(files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir2, SegmentInfo si, IOContext ioContext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        si.addFile(fileName);
        try (IndexOutput output = dir2.createOutput(fileName, ioContext);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 1, si.getId(), "");
            Version version2 = si.getVersion();
            if (version2.major < 5) {
                throw new IllegalArgumentException("invalid major version: should be >= 5 but got: " + version2.major + " segment=" + si);
            }
            output.writeInt(version2.major);
            output.writeInt(version2.minor);
            output.writeInt(version2.bugfix);
            assert (version2.prerelease == 0);
            output.writeInt(si.maxDoc());
            output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
            output.writeMapOfStrings(si.getDiagnostics());
            Set<String> files = si.files();
            for (String file2 : files) {
                if (IndexFileNames.parseSegmentName(file2).equals(si.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + si.name + ", got=" + files);
            }
            output.writeSetOfStrings(files);
            output.writeMapOfStrings(si.getAttributes());
            CodecUtil.writeFooter(output);
        }
    }
}

