/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueInt;

public abstract class IntDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public IntDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc2) {
        return (byte)this.intVal(doc2);
    }

    @Override
    public short shortVal(int doc2) {
        return (short)this.intVal(doc2);
    }

    @Override
    public float floatVal(int doc2) {
        return this.intVal(doc2);
    }

    @Override
    public abstract int intVal(int var1);

    @Override
    public long longVal(int doc2) {
        return this.intVal(doc2);
    }

    @Override
    public double doubleVal(int doc2) {
        return this.intVal(doc2);
    }

    @Override
    public String strVal(int doc2) {
        return Integer.toString(this.intVal(doc2));
    }

    @Override
    public Object objectVal(int doc2) {
        return this.exists(doc2) ? Integer.valueOf(this.intVal(doc2)) : null;
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    @Override
    public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        int upper;
        int lower;
        if (lowerVal == null) {
            lower = Integer.MIN_VALUE;
        } else {
            lower = Integer.parseInt(lowerVal);
            if (!includeLower && lower < Integer.MAX_VALUE) {
                ++lower;
            }
        }
        if (upperVal == null) {
            upper = Integer.MAX_VALUE;
        } else {
            upper = Integer.parseInt(upperVal);
            if (!includeUpper && upper > Integer.MIN_VALUE) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(reader2, this){

            @Override
            public boolean matchesValue(int doc2) {
                int val2 = IntDocValues.this.intVal(doc2);
                return val2 >= ll && val2 <= uu;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueInt mval = new MutableValueInt();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = IntDocValues.this.intVal(doc2);
                this.mval.exists = IntDocValues.this.exists(doc2);
            }
        };
    }
}

