/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueLong;

public abstract class LongDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public LongDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc2) {
        return (byte)this.longVal(doc2);
    }

    @Override
    public short shortVal(int doc2) {
        return (short)this.longVal(doc2);
    }

    @Override
    public float floatVal(int doc2) {
        return this.longVal(doc2);
    }

    @Override
    public int intVal(int doc2) {
        return (int)this.longVal(doc2);
    }

    @Override
    public abstract long longVal(int var1);

    @Override
    public double doubleVal(int doc2) {
        return this.longVal(doc2);
    }

    @Override
    public boolean boolVal(int doc2) {
        return this.longVal(doc2) != 0L;
    }

    @Override
    public String strVal(int doc2) {
        return Long.toString(this.longVal(doc2));
    }

    @Override
    public Object objectVal(int doc2) {
        return this.exists(doc2) ? Long.valueOf(this.longVal(doc2)) : null;
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    protected long externalToLong(String extVal) {
        return Long.parseLong(extVal);
    }

    @Override
    public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        long upper;
        long lower;
        if (lowerVal == null) {
            lower = Long.MIN_VALUE;
        } else {
            lower = this.externalToLong(lowerVal);
            if (!includeLower && lower < Long.MAX_VALUE) {
                ++lower;
            }
        }
        if (upperVal == null) {
            upper = Long.MAX_VALUE;
        } else {
            upper = this.externalToLong(upperVal);
            if (!includeUpper && upper > Long.MIN_VALUE) {
                --upper;
            }
        }
        final long ll = lower;
        final long uu = upper;
        return new ValueSourceScorer(reader2, this){

            @Override
            public boolean matchesValue(int doc2) {
                long val2 = LongDocValues.this.longVal(doc2);
                return val2 >= ll && val2 <= uu;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueLong mval = new MutableValueLong();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                this.mval.value = LongDocValues.this.longVal(doc2);
                this.mval.exists = LongDocValues.this.exists(doc2);
            }
        };
    }
}

