/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.spatial.prefix.AbstractPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SentinelIntSet;

public class ContainsPrefixTreeFilter
extends AbstractPrefixTreeFilter {
    protected final boolean multiOverlappingIndexedShapes;

    public ContainsPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, boolean multiOverlappingIndexedShapes) {
        super(queryShape, fieldName, grid, detailLevel);
        this.multiOverlappingIndexedShapes = multiOverlappingIndexedShapes;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.multiOverlappingIndexedShapes == ((ContainsPrefixTreeFilter)o).multiOverlappingIndexedShapes;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.multiOverlappingIndexedShapes ? 1 : 0);
    }

    @Override
    public String toString(String field) {
        return "ContainsPrefixTreeFilter(fieldName=" + this.fieldName + "," + "queryShape=" + this.queryShape + "," + "detailLevel=" + this.detailLevel + "," + "multiOverlappingIndexedShapes=" + this.multiOverlappingIndexedShapes + ")";
    }

    @Override
    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        return new ContainsVisitor(context, acceptDocs).visit(this.grid.getWorldCell(), acceptDocs);
    }

    private static class SmallDocSet
    extends DocIdSet
    implements Bits {
        private final SentinelIntSet intSet;
        private int maxInt = 0;

        public SmallDocSet(int size) {
            this.intSet = new SentinelIntSet(size, -1);
        }

        @Override
        public boolean get(int index2) {
            return this.intSet.exists(index2);
        }

        public void set(int index2) {
            this.intSet.put(index2);
            if (index2 > this.maxInt) {
                this.maxInt = index2;
            }
        }

        @Override
        public int length() {
            return this.maxInt;
        }

        public int size() {
            return this.intSet.size();
        }

        public SmallDocSet union(SmallDocSet other) {
            SmallDocSet smaller;
            SmallDocSet bigger;
            if (other.intSet.size() > this.intSet.size()) {
                bigger = other;
                smaller = this;
            } else {
                bigger = this;
                smaller = other;
            }
            for (int v : smaller.intSet.keys) {
                if (v == smaller.intSet.emptyVal) continue;
                bigger.set(v);
            }
            return bigger;
        }

        @Override
        public Bits bits() throws IOException {
            return this.size() > 4 ? this : null;
        }

        @Override
        public DocIdSetIterator iterator() throws IOException {
            if (this.size() == 0) {
                return null;
            }
            int d = 0;
            final int[] docs = new int[this.intSet.size()];
            for (int v : this.intSet.keys) {
                if (v == this.intSet.emptyVal) continue;
                docs[d++] = v;
            }
            assert (d == this.intSet.size());
            final int size = d;
            Arrays.sort(docs, 0, size);
            return new DocIdSetIterator(){
                int idx = -1;

                @Override
                public int docID() {
                    if (this.idx < 0) {
                        return -1;
                    }
                    if (this.idx < size) {
                        return docs[this.idx];
                    }
                    return Integer.MAX_VALUE;
                }

                @Override
                public int nextDoc() throws IOException {
                    if (++this.idx < size) {
                        return docs[this.idx];
                    }
                    return Integer.MAX_VALUE;
                }

                @Override
                public int advance(int target) throws IOException {
                    return this.slowAdvance(target);
                }

                @Override
                public long cost() {
                    return size;
                }
            };
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_REF + 4) + this.intSet.ramBytesUsed();
        }
    }

    private class ContainsVisitor
    extends AbstractPrefixTreeFilter.BaseTermsEnumTraverser {
        BytesRef seekTerm;
        BytesRef thisTerm;
        Cell indexedCell;

        public ContainsVisitor(LeafReaderContext context, Bits acceptDocs) throws IOException {
            super(ContainsPrefixTreeFilter.this, context, acceptDocs);
            this.seekTerm = new BytesRef();
            if (this.termsEnum != null) {
                this.nextTerm();
            }
        }

        private SmallDocSet visit(Cell cell, Bits acceptContains) throws IOException {
            if (this.thisTerm == null) {
                return null;
            }
            SmallDocSet combinedSubResults = null;
            Shape subCellsFilter = ContainsPrefixTreeFilter.this.queryShape;
            if (cell.getLevel() != 0 && (cell.getShapeRel() == null || cell.getShapeRel() == SpatialRelation.WITHIN)) {
                subCellsFilter = null;
                assert (cell.getShape().relate(ContainsPrefixTreeFilter.this.queryShape) == SpatialRelation.WITHIN);
            }
            CellIterator subCells = cell.getNextLevelCells(subCellsFilter);
            while (subCells.hasNext()) {
                Cell subCell = subCells.next();
                if (!this.seek(subCell)) {
                    combinedSubResults = null;
                } else if (subCell.getLevel() == ContainsPrefixTreeFilter.this.detailLevel) {
                    combinedSubResults = this.getDocs(subCell, acceptContains);
                } else if (!ContainsPrefixTreeFilter.this.multiOverlappingIndexedShapes && subCell.getShapeRel() == SpatialRelation.WITHIN) {
                    combinedSubResults = this.getLeafDocs(subCell, acceptContains);
                } else {
                    SmallDocSet leafDocs = this.getLeafDocs(subCell, acceptContains);
                    SmallDocSet subDocs = this.visit(subCell, acceptContains);
                    combinedSubResults = this.union(leafDocs, subDocs);
                }
                if (combinedSubResults == null) break;
                acceptContains = combinedSubResults;
            }
            return combinedSubResults;
        }

        private boolean seek(Cell cell) throws IOException {
            if (this.thisTerm == null) {
                return false;
            }
            int compare2 = this.indexedCell.compareToNoLeaf(cell);
            if (compare2 > 0) {
                return false;
            }
            if (compare2 == 0) {
                return true;
            }
            this.seekTerm = cell.getTokenBytesNoLeaf(this.seekTerm);
            TermsEnum.SeekStatus seekStatus = this.termsEnum.seekCeil(this.seekTerm);
            if (seekStatus == TermsEnum.SeekStatus.END) {
                this.thisTerm = null;
                return false;
            }
            this.thisTerm = this.termsEnum.term();
            this.indexedCell = ContainsPrefixTreeFilter.this.grid.readCell(this.thisTerm, this.indexedCell);
            if (seekStatus == TermsEnum.SeekStatus.FOUND) {
                return true;
            }
            return this.indexedCell.isLeaf() && this.indexedCell.compareToNoLeaf(cell) == 0;
        }

        private SmallDocSet getDocs(Cell cell, Bits acceptContains) throws IOException {
            assert (this.indexedCell.compareToNoLeaf(cell) == 0);
            if (this.indexedCell.isLeaf()) {
                SmallDocSet result = this.collectDocs(acceptContains);
                this.nextTerm();
                return result;
            }
            SmallDocSet docsAtPrefix = this.collectDocs(acceptContains);
            if (!this.nextTerm()) {
                return docsAtPrefix;
            }
            if (this.indexedCell.isLeaf() && this.indexedCell.compareToNoLeaf(cell) == 0) {
                SmallDocSet docsAtLeaf = this.collectDocs(acceptContains);
                this.nextTerm();
                return this.union(docsAtPrefix, docsAtLeaf);
            }
            return docsAtPrefix;
        }

        private SmallDocSet getLeafDocs(Cell cell, Bits acceptContains) throws IOException {
            assert (this.indexedCell.compareToNoLeaf(cell) == 0);
            if (!(this.indexedCell.isLeaf() || this.nextTerm() && this.indexedCell.isLeaf() && this.indexedCell.getLevel() == cell.getLevel())) {
                return null;
            }
            SmallDocSet result = this.collectDocs(acceptContains);
            this.nextTerm();
            return result;
        }

        private boolean nextTerm() throws IOException {
            this.thisTerm = this.termsEnum.next();
            if (this.thisTerm == null) {
                return false;
            }
            this.indexedCell = ContainsPrefixTreeFilter.this.grid.readCell(this.thisTerm, this.indexedCell);
            return true;
        }

        private SmallDocSet union(SmallDocSet aSet, SmallDocSet bSet) {
            if (bSet != null) {
                if (aSet == null) {
                    return bSet;
                }
                return aSet.union(bSet);
            }
            return aSet;
        }

        private SmallDocSet collectDocs(Bits acceptContains) throws IOException {
            int docid;
            SmallDocSet set2 = null;
            this.postingsEnum = this.termsEnum.postings(acceptContains, this.postingsEnum, 0);
            while ((docid = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (set2 == null) {
                    int size = this.termsEnum.docFreq();
                    if (size <= 0) {
                        size = 16;
                    }
                    set2 = new SmallDocSet(size);
                }
                set2.set(docid);
            }
            return set2;
        }
    }
}

