/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;

public class DateRangePrefixTree
extends NumberRangePrefixTree {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static Calendar CAL_TMP = Calendar.getInstance(UTC, Locale.ROOT);
    private static final Calendar MINCAL;
    private static final Calendar MAXCAL;
    private static final int BC_FIRSTYEAR;
    private static final int BC_LASTYEAR;
    private static final int BC_YEARS;
    private static final int AD_FIRSTYEAR;
    private static final int AD_LASTYEAR;
    private static final int AD_YEAR_BASE;
    private static final int NUM_MYEARS;
    private static final int[] FIELD_BY_LEVEL;
    private static final int yearLevel = 3;
    public static final DateRangePrefixTree INSTANCE;
    private final NumberRangePrefixTree.UnitNRShape minLV;
    private final NumberRangePrefixTree.UnitNRShape maxLV = this.toShape((Calendar)MAXCAL.clone());
    private final NumberRangePrefixTree.UnitNRShape gregorianChangeDateLV;

    private static int calFieldLen(int field) {
        return CAL_TMP.getMaximum(field) - CAL_TMP.getMinimum(field) + 1;
    }

    protected DateRangePrefixTree() {
        super(new int[]{NUM_MYEARS, 1000, 1000, DateRangePrefixTree.calFieldLen(2), DateRangePrefixTree.calFieldLen(5), DateRangePrefixTree.calFieldLen(11), DateRangePrefixTree.calFieldLen(12), DateRangePrefixTree.calFieldLen(13), DateRangePrefixTree.calFieldLen(14)});
        this.minLV = this.toShape((Calendar)MINCAL.clone());
        if (MAXCAL instanceof GregorianCalendar) {
            GregorianCalendar gCal = (GregorianCalendar)MAXCAL;
            this.gregorianChangeDateLV = this.toUnitShape(gCal.getGregorianChange());
        } else {
            this.gregorianChangeDateLV = null;
        }
    }

    @Override
    public int getNumSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        int cmp = DateRangePrefixTree.comparePrefix(lv, this.maxLV);
        assert (cmp <= 0);
        if (cmp == 0) {
            return this.maxLV.getValAtLevel(lv.getLevel() + 1);
        }
        int n = cmp = this.gregorianChangeDateLV != null ? DateRangePrefixTree.comparePrefix(lv, this.gregorianChangeDateLV) : -1;
        if (cmp >= 0) {
            int result = this.fastSubCells(lv);
            assert (result == this.slowSubCells(lv)) : "fast/slow numSubCells inconsistency";
            return result;
        }
        return this.slowSubCells(lv);
    }

    private int fastSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        if (lv.getLevel() == 4) {
            switch (lv.getValAtLevel(lv.getLevel())) {
                case 3: 
                case 5: 
                case 8: 
                case 10: {
                    return 30;
                }
                case 1: {
                    int yearAdj = lv.getValAtLevel(1) * 1000000;
                    yearAdj += lv.getValAtLevel(2) * 1000;
                    int year = (yearAdj += lv.getValAtLevel(3)) - AD_YEAR_BASE;
                    if (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0)) {
                        return 29;
                    }
                    return 28;
                }
            }
            return 31;
        }
        return super.getNumSubCells(lv);
    }

    private int slowSubCells(NumberRangePrefixTree.UnitNRShape lv) {
        int field = FIELD_BY_LEVEL[lv.getLevel() + 1];
        if (field == -1 || field == 1 || field >= 11) {
            return super.getNumSubCells(lv);
        }
        Calendar cal = this.toCalendar(lv);
        return cal.getActualMaximum(field) - cal.getActualMinimum(field) + 1;
    }

    public Calendar newCal() {
        return (Calendar)CAL_TMP.clone();
    }

    public int getTreeLevelForCalendarField(int calField) {
        for (int i = 3; i < FIELD_BY_LEVEL.length; ++i) {
            if (FIELD_BY_LEVEL[i] == calField) {
                return i;
            }
            if (FIELD_BY_LEVEL[i] <= calField) continue;
            return -1 * i;
        }
        throw new IllegalArgumentException("Bad calendar field?: " + calField);
    }

    public int getCalPrecisionField(Calendar cal) {
        int field;
        int lastField = -1;
        for (int level = 3; level < FIELD_BY_LEVEL.length && cal.isSet(field = FIELD_BY_LEVEL[level]); ++level) {
            lastField = field;
        }
        return lastField;
    }

    public void clearFieldsAfter(Calendar cal, int field) {
        if (field == -1) {
            cal.clear();
            return;
        }
        int assertEra = -1;
        assert ((assertEra = ((Calendar)cal.clone()).get(0)) >= 0);
        for (int f = field + 1; f < 17; ++f) {
            cal.clear(f);
        }
        assert (((Calendar)cal.clone()).get(0) == assertEra) : "Calendar underflow";
    }

    @Override
    public NumberRangePrefixTree.UnitNRShape toUnitShape(Object value) {
        if (value instanceof Calendar) {
            return this.toShape((Calendar)value);
        }
        if (value instanceof Date) {
            Calendar cal = this.newCal();
            cal.setTime((Date)value);
            return this.toShape(cal);
        }
        throw new IllegalArgumentException("Expecting Calendar or Date but got: " + value.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberRangePrefixTree.UnitNRShape toShape(Calendar cal) {
        int calPrecField = this.getCalPrecisionField(cal);
        try {
            int[] valStack = new int[this.maxLevels];
            int len = 0;
            if (calPrecField >= 1) {
                int field;
                int year = cal.get(1);
                int yearAdj = cal.get(0) == 0 ? AD_YEAR_BASE - (year - 1) : AD_YEAR_BASE + year;
                valStack[len++] = yearAdj / 1000000;
                yearAdj -= valStack[len - 1] * 1000000;
                valStack[len++] = yearAdj / 1000;
                yearAdj -= valStack[len - 1] * 1000;
                valStack[len++] = yearAdj;
                for (int level = 4; level < FIELD_BY_LEVEL.length && (field = FIELD_BY_LEVEL[level]) <= calPrecField; ++level) {
                    valStack[len++] = cal.get(field) - cal.getActualMinimum(field);
                }
            }
            NumberRangePrefixTree.UnitNRShape unitNRShape = this.toShape(valStack, len);
            return unitNRShape;
        }
        finally {
            this.clearFieldsAfter(cal, calPrecField);
        }
    }

    @Override
    public Object toObject(NumberRangePrefixTree.UnitNRShape shape) {
        return this.toCalendar(shape);
    }

    public Calendar toCalendar(NumberRangePrefixTree.UnitNRShape lv) {
        if (lv.getLevel() == 0) {
            return this.newCal();
        }
        if (DateRangePrefixTree.comparePrefix(lv, this.minLV) <= 0) {
            return (Calendar)MINCAL.clone();
        }
        assert (DateRangePrefixTree.comparePrefix(lv, this.maxLV) <= 0);
        Calendar cal = this.newCal();
        int yearAdj = lv.getValAtLevel(1) * 1000000;
        if (lv.getLevel() > 1) {
            yearAdj += lv.getValAtLevel(2) * 1000;
            if (lv.getLevel() > 2) {
                yearAdj += lv.getValAtLevel(3);
            }
        }
        if (yearAdj > AD_YEAR_BASE) {
            cal.set(0, 1);
            cal.set(1, yearAdj - AD_YEAR_BASE);
        } else {
            cal.set(0, 0);
            cal.set(1, AD_YEAR_BASE - yearAdj + 1);
        }
        for (int level = 4; level <= lv.getLevel(); ++level) {
            int field = FIELD_BY_LEVEL[level];
            cal.set(field, lv.getValAtLevel(level) + cal.getActualMinimum(field));
        }
        assert (yearAdj > AD_YEAR_BASE || ((Calendar)cal.clone()).get(0) == 0) : "ERA / YEAR underflow";
        return cal;
    }

    @Override
    protected String toString(NumberRangePrefixTree.UnitNRShape lv) {
        return this.toString(this.toCalendar(lv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Calendar cal) {
        int calPrecField = this.getCalPrecisionField(cal);
        if (calPrecField == -1) {
            return "*";
        }
        try {
            String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            int ptnLen = 0;
            switch (calPrecField) {
                case 14: {
                    ptnLen += 4;
                }
                case 13: {
                    ptnLen += 3;
                }
                case 12: {
                    ptnLen += 3;
                }
                case 11: {
                    ptnLen += 5;
                }
                case 5: {
                    ptnLen += 3;
                }
                case 2: {
                    ptnLen += 3;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("" + calPrecField);
                }
            }
            pattern = pattern.substring(0, ptnLen += 4);
            SimpleDateFormat format2 = new SimpleDateFormat(pattern, Locale.ROOT);
            format2.setTimeZone(cal.getTimeZone());
            if (cal.get(0) == 0) {
                String str2;
                int yearOrig = cal.get(1);
                cal.set(1, yearOrig - 1);
                try {
                    str2 = format2.format(cal.getTime());
                }
                finally {
                    cal.set(0, 0);
                    cal.set(1, yearOrig);
                }
                if (yearOrig > 1) {
                    String string2 = "-" + str2;
                    return string2;
                }
                String string3 = "0000" + str2.substring(4);
                return string3;
            }
            String string4 = format2.format(cal.getTime());
            return string4;
        }
        finally {
            this.clearFieldsAfter(cal, calPrecField);
        }
    }

    @Override
    protected NumberRangePrefixTree.UnitNRShape parseUnitShape(String str2) throws ParseException {
        return this.toShape(this.parseCalendar(str2));
    }

    public Calendar parseCalendar(String str2) throws ParseException {
        if (str2 == null || str2.isEmpty()) {
            throw new IllegalArgumentException("str is null or blank");
        }
        Calendar cal = this.newCal();
        if (str2.equals("*")) {
            return cal;
        }
        int offset = 0;
        try {
            int year;
            int lastOffset = str2.charAt(str2.length() - 1) == 'Z' ? str2.length() - 1 : str2.length();
            int hyphenIdx = str2.indexOf(45, 1);
            if (hyphenIdx < 0) {
                hyphenIdx = lastOffset;
            }
            cal.set(0, (year = Integer.parseInt(str2.substring(offset, hyphenIdx))) <= 0 ? 0 : 1);
            cal.set(1, year <= 0 ? -1 * year + 1 : year);
            offset = hyphenIdx + 1;
            if (lastOffset < offset) {
                return cal;
            }
            cal.set(2, Integer.parseInt(str2.substring(offset, offset + 2)) - 1);
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(5, Integer.parseInt(str2.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(11, Integer.parseInt(str2.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(12, Integer.parseInt(str2.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(13, Integer.parseInt(str2.substring(offset, offset + 2)));
            if (lastOffset < (offset += 3)) {
                return cal;
            }
            cal.set(14, Integer.parseInt(str2.substring(offset, offset + 3)));
            if (lastOffset == (offset += 3)) {
                return cal;
            }
        }
        catch (Exception e2) {
            ParseException pe = new ParseException("Improperly formatted date: " + str2, offset);
            pe.initCause(e2);
            throw pe;
        }
        throw new ParseException("Improperly formatted date: " + str2, offset);
    }

    static {
        CAL_TMP.clear();
        MINCAL = (Calendar)CAL_TMP.clone();
        MAXCAL = (Calendar)CAL_TMP.clone();
        MINCAL.setTimeInMillis(Long.MIN_VALUE);
        MAXCAL.setTimeInMillis(Long.MAX_VALUE);
        BC_FIRSTYEAR = MINCAL.getActualMaximum(1);
        BC_LASTYEAR = MINCAL.getActualMinimum(1);
        BC_YEARS = BC_FIRSTYEAR - BC_LASTYEAR + 1;
        AD_FIRSTYEAR = MAXCAL.getActualMinimum(1);
        AD_LASTYEAR = MAXCAL.getActualMaximum(1);
        AD_YEAR_BASE = ((BC_YEARS - 1) / 1000000 + 1) * 1000000;
        assert (BC_LASTYEAR == 1 && AD_FIRSTYEAR == 1);
        NUM_MYEARS = (AD_YEAR_BASE + AD_LASTYEAR) / 1000000;
        FIELD_BY_LEVEL = new int[]{-1, -1, -1, 1, 2, 5, 11, 12, 13, 14};
        INSTANCE = new DateRangePrefixTree();
    }
}

