/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

public class GrowableWriter
extends PackedInts.Mutable {
    private long currentMask;
    private PackedInts.Mutable current;
    private final float acceptableOverheadRatio;

    public GrowableWriter(int startBitsPerValue, int valueCount, float acceptableOverheadRatio) {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        this.current = PackedInts.getMutable(valueCount, startBitsPerValue, this.acceptableOverheadRatio);
        this.currentMask = GrowableWriter.mask(this.current.getBitsPerValue());
    }

    private static long mask(int bitsPerValue) {
        return bitsPerValue == 64 ? -1L : PackedInts.maxValue(bitsPerValue);
    }

    @Override
    public long get(int index2) {
        return this.current.get(index2);
    }

    @Override
    public int size() {
        return this.current.size();
    }

    @Override
    public int getBitsPerValue() {
        return this.current.getBitsPerValue();
    }

    public PackedInts.Mutable getMutable() {
        return this.current;
    }

    private void ensureCapacity(long value) {
        if ((value & this.currentMask) == value) {
            return;
        }
        int bitsRequired = PackedInts.unsignedBitsRequired(value);
        assert (bitsRequired > this.current.getBitsPerValue());
        int valueCount = this.size();
        PackedInts.Mutable next2 = PackedInts.getMutable(valueCount, bitsRequired, this.acceptableOverheadRatio);
        PackedInts.copy((PackedInts.Reader)this.current, 0, next2, 0, valueCount, 1024);
        this.current = next2;
        this.currentMask = GrowableWriter.mask(this.current.getBitsPerValue());
    }

    @Override
    public void set(int index2, long value) {
        this.ensureCapacity(value);
        this.current.set(index2, value);
    }

    @Override
    public void clear() {
        this.current.clear();
    }

    public GrowableWriter resize(int newSize) {
        GrowableWriter next2 = new GrowableWriter(this.getBitsPerValue(), newSize, this.acceptableOverheadRatio);
        int limit = Math.min(this.size(), newSize);
        PackedInts.copy((PackedInts.Reader)this.current, 0, (PackedInts.Mutable)next2, 0, limit, 1024);
        return next2;
    }

    @Override
    public int get(int index2, long[] arr, int off, int len) {
        return this.current.get(index2, arr, off, len);
    }

    @Override
    public int set(int index2, long[] arr, int off, int len) {
        long max2 = 0L;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            max2 |= arr[i];
        }
        this.ensureCapacity(max2);
        return this.current.set(index2, arr, off, len);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val2) {
        this.ensureCapacity(val2);
        this.current.fill(fromIndex, toIndex, val2);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 4) + this.current.ramBytesUsed();
    }

    @Override
    public void save(DataOutput out) throws IOException {
        this.current.save(out);
    }
}

