/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;

public abstract class QueueIteration<E, T extends Exception>
extends LookAheadIteration<E, T> {
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final BlockingQueue<E> queue;
    private final E afterLast = this.createAfterLast();
    private final Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();

    public QueueIteration(int capacity) {
        this(capacity, false);
    }

    public QueueIteration(int capacity, boolean fair) {
        this.queue = new ArrayBlockingQueue(capacity, fair);
    }

    public QueueIteration(BlockingQueue<E> queue) {
        this.queue = queue;
    }

    protected abstract T convert(Exception var1);

    public void toss(Exception exception) {
        this.exceptions.add(exception);
    }

    public void put(E item) throws InterruptedException, T {
        try {
            while (!(this.isClosed() || this.done.get() || Thread.currentThread().isInterrupted() || this.queue.offer(item, 1L, TimeUnit.SECONDS))) {
            }
            if (this.done.get() || Thread.currentThread().isInterrupted()) {
                this.close();
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            this.close();
            throw e2;
        }
    }

    public void done() {
        this.done.lazySet(true);
        boolean offer = this.queue.offer(this.afterLast);
        if (!offer) {
            // empty if block
        }
    }

    @Override
    public E getNextElement() throws T {
        if (this.isClosed()) {
            return null;
        }
        try {
            Object take2;
            this.checkException();
            if (this.done.get()) {
                take2 = this.queue.poll();
            } else {
                take2 = this.queue.take();
                if (this.done.get()) {
                    this.done();
                }
            }
            if (this.isAfterLast(take2)) {
                this.checkException();
                this.done();
                return null;
            }
            this.checkException();
            return take2;
        }
        catch (InterruptedException e2) {
            this.checkException();
            this.close();
            throw this.convert(e2);
        }
    }

    @Override
    public void handleClose() throws T {
        try {
            super.handleClose();
        }
        finally {
            this.done.set(true);
            do {
                this.queue.clear();
            } while (!this.queue.offer(this.afterLast));
            this.checkException();
        }
    }

    public void checkException() throws T {
        if (!this.exceptions.isEmpty()) {
            try {
                this.close();
                throw this.exceptions.remove();
            }
            catch (Exception e2) {
                throw this.convert(e2);
            }
        }
    }

    private boolean isAfterLast(E take2) {
        return take2 == null || take2 == this.afterLast;
    }

    private E createAfterLast() {
        return (E)new Object();
    }
}

