/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.util.URIUtil;

public class SimpleIRI
implements IRI {
    private static final long serialVersionUID = -7330406348751485330L;
    private String iriString;
    private int localNameIdx;

    protected SimpleIRI() {
    }

    protected SimpleIRI(String iriString) {
        this.setIRIString(iriString);
    }

    protected void setIRIString(String iriString) {
        Objects.requireNonNull(iriString, "iriString must not be null");
        if (iriString.indexOf(58) < 0) {
            throw new IllegalArgumentException("Not a valid (absolute) IRI: " + iriString);
        }
        this.iriString = iriString;
        this.localNameIdx = -1;
    }

    @Override
    public String toString() {
        return this.iriString;
    }

    @Override
    public String stringValue() {
        return this.iriString;
    }

    @Override
    public String getNamespace() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.iriString);
        }
        return this.iriString.substring(0, this.localNameIdx);
    }

    @Override
    public String getLocalName() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.iriString);
        }
        return this.iriString.substring(this.localNameIdx);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IRI) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.iriString.hashCode();
    }
}

