/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.QueryParser;
import org.eclipse.rdf4j.query.parser.serql.AnonymousVarGenerator;
import org.eclipse.rdf4j.query.parser.serql.NamespaceDeclProcessor;
import org.eclipse.rdf4j.query.parser.serql.NullProcessor;
import org.eclipse.rdf4j.query.parser.serql.ProjectionAliasProcessor;
import org.eclipse.rdf4j.query.parser.serql.ProjectionProcessor;
import org.eclipse.rdf4j.query.parser.serql.QueryModelBuilder;
import org.eclipse.rdf4j.query.parser.serql.StringEscapesProcessor;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTGraphQuery;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQuery;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTTupleQuery;
import org.eclipse.rdf4j.query.parser.serql.ast.ParseException;
import org.eclipse.rdf4j.query.parser.serql.ast.SyntaxTreeBuilder;
import org.eclipse.rdf4j.query.parser.serql.ast.TokenMgrError;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;

public class SeRQLParser
implements QueryParser {
    @Override
    public ParsedQuery parseQuery(String queryStr, String baseURI) throws MalformedQueryException {
        try {
            ParsedQuery query;
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery(queryStr);
            NullProcessor.process(qc);
            StringEscapesProcessor.process(qc);
            Map<String, String> namespaces = NamespaceDeclProcessor.process(qc);
            ProjectionProcessor.process(qc);
            qc.jjtAccept(new ProjectionAliasProcessor(), null);
            qc.jjtAccept(new AnonymousVarGenerator(), null);
            TupleExpr tupleExpr = QueryModelBuilder.buildQueryModel(qc, SimpleValueFactory.getInstance());
            ASTQuery queryNode = qc.getQuery();
            if (queryNode instanceof ASTTupleQuery) {
                query = new ParsedTupleQuery(tupleExpr);
            } else if (queryNode instanceof ASTGraphQuery) {
                query = new ParsedGraphQuery(tupleExpr, namespaces);
            } else {
                throw new RuntimeException("Unexpected query type: " + queryNode.getClass());
            }
            return query;
        }
        catch (ParseException e2) {
            throw new MalformedQueryException(e2.getMessage(), e2);
        }
        catch (TokenMgrError e3) {
            throw new MalformedQueryException(e3.getMessage(), e3);
        }
        catch (VisitorException e4) {
            throw new MalformedQueryException(e4.getMessage(), e4);
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Your SeRQL query:");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        StringBuilder buf = new StringBuilder();
        String line = null;
        while ((line = in.readLine()) != null) {
            if (line.length() > 0) {
                buf.append(' ').append(line).append('\n');
                continue;
            }
            String queryStr = buf.toString().trim();
            if (queryStr.length() > 0) {
                try {
                    SeRQLParser parser = new SeRQLParser();
                    parser.parseQuery(queryStr, null);
                }
                catch (Exception e2) {
                    System.err.println(e2.getMessage());
                    e2.printStackTrace();
                }
            }
            buf.setLength(0);
        }
    }

    @Override
    public ParsedUpdate parseUpdate(String updateStr, String baseURI) throws MalformedQueryException {
        throw new UnsupportedOperationException("SeRQL does not support update operations");
    }
}

