/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.http;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPUpdate;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.http.HTTPRepositoryConnection;
import org.eclipse.rdf4j.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractHTTPUpdate {
    private final HTTPRepositoryConnection httpCon;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con.getSesameSession(), ql, queryString, baseURI);
        this.httpCon = con;
    }

    @Override
    public void execute() throws UpdateExecutionException {
        try {
            if (this.httpCon.getRepository().useCompatibleMode()) {
                if (this.httpCon.isAutoCommit()) {
                    SPARQLProtocolSession client = this.getHttpClient();
                    try {
                        client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
                    }
                    catch (UnauthorizedException e2) {
                        throw new HTTPUpdateExecutionException(e2.getMessage(), e2);
                    }
                    catch (QueryInterruptedException e3) {
                        throw new HTTPUpdateExecutionException(e3.getMessage(), e3);
                    }
                    catch (MalformedQueryException e4) {
                        throw new HTTPUpdateExecutionException(e4.getMessage(), e4);
                    }
                    catch (IOException e5) {
                        throw new HTTPUpdateExecutionException(e5.getMessage(), e5);
                    }
                } else {
                    this.httpCon.scheduleUpdate(this);
                }
                return;
            }
            SPARQLProtocolSession client = this.getHttpClient();
            try {
                this.httpCon.flushTransactionState(Protocol.Action.UPDATE);
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
            }
            catch (UnauthorizedException e6) {
                throw new HTTPUpdateExecutionException(e6.getMessage(), e6);
            }
            catch (QueryInterruptedException e7) {
                throw new HTTPUpdateExecutionException(e7.getMessage(), e7);
            }
            catch (MalformedQueryException e8) {
                throw new HTTPUpdateExecutionException(e8.getMessage(), e8);
            }
            catch (IOException e9) {
                throw new HTTPUpdateExecutionException(e9.getMessage(), e9);
            }
        }
        catch (RepositoryException e10) {
            throw new HTTPUpdateExecutionException(e10.getMessage(), e10);
        }
    }
}

