/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrefixHashSet {
    private int length = Integer.MAX_VALUE;
    private final Map<String, List<String>> index = new HashMap<String, List<String>>();

    public PrefixHashSet(Iterable<String> values) {
        for (String value : values) {
            if (value.length() >= this.length) continue;
            this.length = value.length();
        }
        for (String value : values) {
            String key2 = value.substring(0, this.length);
            List<String> entry = this.index.get(key2);
            if (entry == null) {
                entry = new ArrayList<String>();
                this.index.put(key2, entry);
            }
            entry.add(value.substring(this.length));
        }
    }

    public boolean match(String value) {
        String key2;
        List<String> entry;
        boolean result = false;
        if (value.length() >= this.length && (entry = this.index.get(key2 = value.substring(0, this.length))) != null) {
            result = this.matchValueToEntry(value, entry);
        }
        return result;
    }

    private boolean matchValueToEntry(String value, List<String> entry) {
        boolean result = false;
        String tail = value.substring(this.length);
        for (String prefix : entry) {
            if (!tail.startsWith(prefix)) continue;
            result = true;
            break;
        }
        return result;
    }

    public String toString() {
        return this.index.toString();
    }
}

