/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.sail.memory.model.MemLiteral;

public class CalendarMemLiteral
extends MemLiteral {
    private static final long serialVersionUID = -7903843639313451580L;
    private transient XMLGregorianCalendar calendar;

    public CalendarMemLiteral(Object creator, XMLGregorianCalendar calendar) {
        this(creator, calendar.toXMLFormat(), calendar);
    }

    public CalendarMemLiteral(Object creator, String label, XMLGregorianCalendar calendar) {
        this(creator, label, XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()), calendar);
    }

    public CalendarMemLiteral(Object creator, String label, IRI datatype, XMLGregorianCalendar calendar) {
        super(creator, label, datatype);
        this.calendar = calendar;
    }

    @Override
    public XMLGregorianCalendar calendarValue() {
        return this.calendar;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
            this.calendar = XMLDatatypeUtil.parseCalendar(this.getLabel());
        }
        catch (ClassNotFoundException e2) {
            throw new IOException(e2.getMessage());
        }
    }
}

