/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mapdb.BTreeKeySerializer;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.Engine;
import org.mapdb.Fun;
import org.mapdb.Serializer;
import org.mapdb.Store;

public final class Pump {
    static void copy(DB db1, DB db2) {
        Pump.copy(Store.forDB(db1), Store.forDB(db2));
        db2.engine.clearCache();
        db2.reinit();
    }

    static void copy(Store s1, Store s2) {
        long maxRecid = s1.getMaxRecid();
        for (long recid = 1L; recid <= maxRecid; ++recid) {
            ByteBuffer bb = s1.getRaw(recid);
            if (bb == null) continue;
            s2.updateRaw(recid, bb);
        }
        Iterator<Long> iter = s1.getFreeRecids();
        while (iter.hasNext()) {
            s2.delete(iter.next(), null);
        }
    }

    public static <E> Iterator<E> sort(Iterator<E> source2, boolean mergeDuplicates, int batchSize, Comparator comparator2, final Serializer serializer) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (comparator2 == null) {
            comparator2 = BTreeMap.COMPARABLE_COMPARATOR;
        }
        if (source2 == null) {
            source2 = Fun.EMPTY_ITERATOR;
        }
        int counter = 0;
        Object[] presort = new Object[batchSize];
        final ArrayList<Object> presortFiles = new ArrayList<Object>();
        ArrayList<Integer> presortCount2 = new ArrayList<Integer>();
        try {
            Object f;
            while (source2.hasNext()) {
                presort[counter] = source2.next();
                if (++counter < batchSize) continue;
                Arrays.sort(presort, comparator2);
                f = File.createTempFile("mapdb", "sort");
                ((File)f).deleteOnExit();
                presortFiles.add(f);
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((File)f)));
                for (Object e2 : presort) {
                    serializer.serialize(out, e2);
                }
                out.close();
                presortCount2.add(counter);
                Arrays.fill(presort, (Object)0);
                counter = 0;
            }
            if (presortFiles.isEmpty()) {
                Arrays.sort(presort, 0, counter, comparator2);
                f = Pump.arrayIterator(presort, 0, counter);
                return f;
            }
            final int[] presortCount = new int[presortFiles.size()];
            for (int i = 0; i < presortCount.length; ++i) {
                presortCount[i] = (Integer)presortCount2.get(i);
            }
            Iterator[] iterators = new Iterator[presortFiles.size() + 1];
            final DataInputStream[] ins = new DataInputStream[presortFiles.size()];
            for (int i = 0; i < presortFiles.size(); ++i) {
                ins[i] = new DataInputStream(new BufferedInputStream(new FileInputStream((File)presortFiles.get(i))));
                final int pos = i;
                iterators[i] = new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return presortCount[pos] > 0;
                    }

                    public Object next() {
                        try {
                            Object ret = serializer.deserialize(ins[pos], -1);
                            int n = pos;
                            presortCount[n] = presortCount[n] - 1;
                            if (presortCount[n] == 0) {
                                ins[pos].close();
                                ((File)presortFiles.get(pos)).delete();
                            }
                            return ret;
                        }
                        catch (IOException e2) {
                            throw new IOError(e2);
                        }
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            Arrays.sort(presort, 0, counter, comparator2);
            iterators[iterators.length - 1] = Pump.arrayIterator(presort, 0, counter);
            Iterator<E> iterator = Pump.sort(comparator2, mergeDuplicates, iterators);
            return iterator;
        }
        catch (IOException e3) {
            throw new IOError(e3);
        }
        finally {
            for (File file2 : presortFiles) {
                file2.delete();
            }
        }
    }

    public static <E> Iterator<E> sort(Comparator comparator2, final boolean mergeDuplicates, final Iterator ... iterators) {
        final Comparator comparator22 = comparator2 == null ? BTreeMap.COMPARABLE_COMPARATOR : comparator2;
        return new Iterator<E>(){
            final NavigableSet<Fun.Tuple2<Object, Integer>> items;
            Object next;
            {
                this.items = new TreeSet<Fun.Tuple2<Object, Integer>>(new Fun.Tuple2Comparator(comparator22, null));
                this.next = this;
                for (int i = 0; i < iterators.length; ++i) {
                    if (!iterators[i].hasNext()) continue;
                    this.items.add(Fun.t2(iterators[i].next(), i));
                }
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object oldNext = this.next;
                Fun.Tuple2<Object, Integer> lo = this.items.pollFirst();
                if (lo == null) {
                    this.next = null;
                    return oldNext;
                }
                this.next = lo.a;
                if (oldNext != this && comparator22.compare(oldNext, this.next) > 0) {
                    throw new IllegalArgumentException("One of the iterators is not sorted");
                }
                Iterator iter = iterators[(Integer)lo.b];
                if (iter.hasNext()) {
                    this.items.add(Fun.t2(iter.next(), lo.b));
                }
                if (mergeDuplicates) {
                    SortedSet<Fun.Tuple2<Object, Object>> subset;
                    while (!(subset = this.items.subSet(Fun.t2(this.next, null), Fun.t2(this.next, Fun.HI))).isEmpty()) {
                        ArrayList toadd = new ArrayList();
                        for (Fun.Tuple2 tuple2 : subset) {
                            iter = iterators[(Integer)tuple2.b];
                            if (!iter.hasNext()) continue;
                            toadd.add(Fun.t2(iter.next(), tuple2.b));
                        }
                        subset.clear();
                        this.items.addAll(toadd);
                    }
                }
                return oldNext;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterator<E> merge(final Iterator ... iters) {
        if (iters.length == 0) {
            return Fun.EMPTY_ITERATOR;
        }
        return new Iterator<E>(){
            int i = 0;
            Object next = this;
            {
                this.next();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                while (!iters[this.i].hasNext()) {
                    ++this.i;
                    if (this.i != iters.length) continue;
                    Object ret = this.next;
                    this.next = null;
                    return ret;
                }
                Object ret = this.next;
                this.next = iters[this.i].next();
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E, K, V> long buildTreeMap(Iterator<E> source2, Engine engine, Fun.Function1<K, E> keyExtractor, Fun.Function1<V, E> valueExtractor, boolean ignoreDuplicates, int nodeSize, boolean valuesStoredOutsideNodes, long counterRecid, BTreeKeySerializer<K> keySerializer, Serializer<V> valueSerializer, Comparator comparator2) {
        if (comparator2 == null) {
            comparator2 = BTreeMap.COMPARABLE_COMPARATOR;
        }
        double NODE_LOAD = 0.75;
        BTreeMap.NodeSerializer nodeSerializer = new BTreeMap.NodeSerializer(valuesStoredOutsideNodes, keySerializer, valueSerializer, comparator2, 0);
        int nload = (int)((double)nodeSize * 0.75);
        ArrayList<ArrayList<Object>> dirKeys = Pump.arrayList(Pump.arrayList(null));
        ArrayList<ArrayList<Long>> dirRecids = Pump.arrayList(Pump.arrayList(0L));
        long counter = 0L;
        long nextNode = 0L;
        ArrayList<Object> keys2 = Pump.arrayList(null);
        ArrayList<Object> values = new ArrayList<Object>();
        Object oldKey = null;
        while (source2.hasNext()) {
            block1: for (int i = 0; i < nload && source2.hasNext(); ++i) {
                Object val2;
                int compared;
                ++counter;
                E next2 = source2.next();
                if (next2 == null) {
                    throw new NullPointerException("source returned null element");
                }
                E key2 = keyExtractor == null ? next2 : keyExtractor.run(next2);
                int n = compared = oldKey == null ? -1 : comparator2.compare(key2, oldKey);
                while (ignoreDuplicates && compared == 0) {
                    if (!source2.hasNext()) break block1;
                    next2 = source2.next();
                    if (next2 == null) {
                        throw new NullPointerException("source returned null element");
                    }
                    key2 = keyExtractor == null ? next2 : keyExtractor.run(next2);
                    compared = comparator2.compare(key2, oldKey);
                }
                if (oldKey != null && compared >= 0) {
                    throw new IllegalArgumentException("Keys in 'source' iterator are not reverse sorted");
                }
                oldKey = key2;
                keys2.add(key2);
                Object object = val2 = valueExtractor != null ? valueExtractor.run(next2) : BTreeMap.EMPTY;
                if (val2 == null) {
                    throw new NullPointerException("extractValue returned null value");
                }
                if (valuesStoredOutsideNodes) {
                    long recid = engine.put(val2, valueSerializer);
                    val2 = new BTreeMap.ValRef(recid);
                }
                values.add(val2);
            }
            if (!source2.hasNext()) {
                keys2.add(null);
                values.add(null);
            }
            Collections.reverse(keys2);
            Object nextVal = values.remove(values.size() - 1);
            Collections.reverse(values);
            BTreeMap.LeafNode node2 = new BTreeMap.LeafNode(keys2.toArray(), values.toArray(), nextNode);
            nextNode = engine.put(node2, nodeSerializer);
            Object nextKey = keys2.get(0);
            keys2.clear();
            keys2.add(nextKey);
            keys2.add(nextKey);
            values.clear();
            values.add(nextVal);
            dirKeys.get(0).add(node2.keys()[0]);
            dirRecids.get(0).add(nextNode);
            for (int i = 0; i < dirKeys.size() && dirKeys.get(i).size() >= nload; ++i) {
                Collections.reverse((List)dirKeys.get(i));
                Collections.reverse((List)dirRecids.get(i));
                BTreeMap.DirNode dir2 = new BTreeMap.DirNode(dirKeys.get(i).toArray(), (List<Long>)dirRecids.get(i));
                long dirRecid = engine.put(dir2, nodeSerializer);
                Object dirStart = dirKeys.get(i).get(0);
                dirKeys.get(i).clear();
                dirKeys.get(i).add(dirStart);
                dirRecids.get(i).clear();
                dirRecids.get(i).add(dirRecid);
                if (dirKeys.size() == i + 1) {
                    dirKeys.add(Pump.arrayList(dirStart));
                    dirRecids.add(Pump.arrayList(dirRecid));
                    continue;
                }
                dirKeys.get(i + 1).add(dirStart);
                dirRecids.get(i + 1).add(dirRecid);
            }
        }
        for (int i = 0; i < dirKeys.size() - 1; ++i) {
            ArrayList<Object> keys22 = dirKeys.get(i);
            Collections.reverse(keys22);
            Collections.reverse((List)dirRecids.get(i));
            if (keys22.size() > 2 && keys22.get(0) == null && keys22.get(1) == null) {
                keys22.remove(0);
                dirRecids.get(i).remove(0);
            }
            BTreeMap.DirNode dir3 = new BTreeMap.DirNode(keys22.toArray(), (List<Long>)dirRecids.get(i));
            long dirRecid = engine.put(dir3, nodeSerializer);
            Object dirStart = keys22.get(0);
            dirKeys.get(i + 1).add(dirStart);
            dirRecids.get(i + 1).add(dirRecid);
        }
        int len = dirKeys.size() - 1;
        Collections.reverse((List)dirKeys.get(len));
        Collections.reverse((List)dirRecids.get(len));
        if (counterRecid != 0L) {
            engine.update(counterRecid, counter, Serializer.LONG);
        }
        BTreeMap.DirNode dir4 = new BTreeMap.DirNode(dirKeys.get(len).toArray(), (List<Long>)dirRecids.get(len));
        long rootRecid = engine.put(dir4, nodeSerializer);
        return engine.put(rootRecid, Serializer.LONG);
    }

    private static <E> ArrayList<E> arrayList(E item) {
        ArrayList<E> ret = new ArrayList<E>();
        ret.add(item);
        return ret;
    }

    private static <E> Iterator<E> arrayIterator(final Object[] array2, final int fromIndex, final int toIndex) {
        return new Iterator<E>(){
            int index;
            {
                this.index = fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < toIndex;
            }

            @Override
            public E next() {
                if (this.index >= toIndex) {
                    throw new NoSuchElementException();
                }
                return array2[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

