/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class Lucene50NormsProducer
extends NormsProducer {
    private final Map<String, NormsEntry> norms;
    private final IndexInput data;
    final Map<String, Norms> instances;
    private final AtomicLong ramBytesUsed;
    private final AtomicInteger activeCount;
    private final int maxDoc;
    private final boolean merging;

    Lucene50NormsProducer(Lucene50NormsProducer original) {
        this.norms = new HashMap<String, NormsEntry>();
        this.instances = new HashMap<String, Norms>();
        this.activeCount = new AtomicInteger();
        assert (Thread.holdsLock(original));
        this.norms.putAll(original.norms);
        this.data = original.data.clone();
        this.instances.putAll(original.instances);
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.activeCount.set(original.activeCount.get());
        this.maxDoc = original.maxDoc;
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene50NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version2;
        block20: {
            this.norms = new HashMap<String, NormsEntry>();
            this.instances = new HashMap<String, Norms>();
            this.activeCount = new AtomicInteger();
            this.merging = false;
            this.maxDoc = state.segmentInfo.maxDoc();
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            version2 = -1;
            try (ChecksumIndexInput in = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version2 = CodecUtil.checkIndexHeader(in, metaCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(in, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in, priorE);
                    }
                }
                CodecUtil.checkFooter(in, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version22 = CodecUtil.checkIndexHeader(this.data, dataCodec, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            if (version2 != version22) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version2 + ",data=" + version22, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info2 = infos.fieldInfo(fieldNumber);
            if (info2 == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info2.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info2.name, meta);
            }
            NormsEntry entry = this.readEntry(info2, meta);
            this.norms.put(info2.name, entry);
            fieldNumber = meta.readVInt();
        }
    }

    private NormsEntry readEntry(FieldInfo info2, IndexInput meta) throws IOException {
        NormsEntry entry = new NormsEntry();
        entry.count = meta.readVInt();
        entry.format = meta.readByte();
        entry.offset = meta.readLong();
        switch (entry.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                if (meta.readVInt() != info2.number) {
                    throw new CorruptIndexException("indirect norms entry for field: " + info2.name + " is corrupt", meta);
                }
                entry.nested = this.readEntry(info2, meta);
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, meta);
            }
        }
        return entry;
    }

    @Override
    public synchronized NumericDocValues getNorms(FieldInfo field) throws IOException {
        Norms instance = this.instances.get(field.name);
        if (instance == null) {
            instance = this.loadNorms(this.norms.get(field.name));
            if (!this.merging) {
                this.instances.put(field.name, instance);
                this.activeCount.incrementAndGet();
                this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
            }
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.instances);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private Norms loadNorms(NormsEntry entry) throws IOException {
        switch (entry.format) {
            case 2: {
                final long v = entry.offset;
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        return v;
                    }

                    @Override
                    public long ramBytesUsed() {
                        return 8L;
                    }

                    public String toString() {
                        return "constant";
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        return Collections.emptyList();
                    }
                };
            }
            case 3: {
                this.data.seek(entry.offset);
                final byte[] bytes2 = new byte[entry.count];
                this.data.readBytes(bytes2, 0, bytes2.length);
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        return bytes2[docID];
                    }

                    @Override
                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf(bytes2);
                    }

                    public String toString() {
                        return "byte array";
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        return Collections.emptyList();
                    }
                };
            }
            case 0: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                final BlockPackedReader reader2 = new BlockPackedReader(this.data, packedIntsVersion, blockSize, entry.count, false);
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        return reader2.get(docID);
                    }

                    @Override
                    public long ramBytesUsed() {
                        return reader2.ramBytesUsed();
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        return Collections.singleton(Accountables.namedAccountable("deltas", reader2));
                    }

                    public String toString() {
                        return "delta compressed";
                    }
                };
            }
            case 1: {
                int i;
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                if (bitsPerValue != 1 && bitsPerValue != 2 && bitsPerValue != 4) {
                    throw new CorruptIndexException("TABLE_COMPRESSED only supports bpv=1, bpv=2 and bpv=4, got=" + bitsPerValue, this.data);
                }
                int size = 1 << bitsPerValue;
                final byte[] decode = new byte[size];
                int ordsSize = this.data.readVInt();
                for (i = 0; i < ordsSize; ++i) {
                    decode[i] = this.data.readByte();
                }
                for (i = ordsSize; i < size; ++i) {
                    decode[i] = 0;
                }
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), packedIntsVersion, entry.count, bitsPerValue);
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }

                    @Override
                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed();
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        return Collections.singleton(Accountables.namedAccountable("ordinals", ordsReader));
                    }

                    public String toString() {
                        return "table compressed";
                    }
                };
            }
            case 4: {
                this.data.seek(entry.offset);
                final long common = this.data.readLong();
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                final MonotonicBlockPackedReader live = MonotonicBlockPackedReader.of(this.data, packedIntsVersion, blockSize, entry.count, false);
                final Norms nestedInstance = this.loadNorms(entry.nested);
                final int upperBound = entry.count - 1;
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        int low = 0;
                        int high = upperBound;
                        while (low <= high) {
                            int mid = low + high >>> 1;
                            long doc2 = live.get(mid);
                            if (doc2 < (long)docID) {
                                low = mid + 1;
                                continue;
                            }
                            if (doc2 > (long)docID) {
                                high = mid - 1;
                                continue;
                            }
                            return nestedInstance.get(mid);
                        }
                        return common;
                    }

                    @Override
                    public long ramBytesUsed() {
                        return live.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children2 = new ArrayList<Accountable>();
                        children2.add(Accountables.namedAccountable("keys", live));
                        children2.add(Accountables.namedAccountable("values", nestedInstance));
                        return Collections.unmodifiableList(children2);
                    }

                    public String toString() {
                        return "indirect";
                    }
                };
            }
            case 5: {
                this.data.seek(entry.offset);
                final long common = this.data.readLong();
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                MonotonicBlockPackedReader live = MonotonicBlockPackedReader.of(this.data, packedIntsVersion, blockSize, entry.count, true);
                final SparseFixedBitSet set2 = new SparseFixedBitSet(this.maxDoc);
                int i = 0;
                while ((long)i < live.size()) {
                    int doc2 = (int)live.get(i);
                    set2.set(doc2);
                    ++i;
                }
                final Norms nestedInstance = this.loadNorms(entry.nested);
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        if (set2.get(docID)) {
                            return nestedInstance.get(docID);
                        }
                        return common;
                    }

                    @Override
                    public long ramBytesUsed() {
                        return set2.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children2 = new ArrayList<Accountable>();
                        children2.add(Accountables.namedAccountable("keys", set2));
                        children2.add(Accountables.namedAccountable("values", nestedInstance));
                        return Collections.unmodifiableList(children2);
                    }

                    public String toString() {
                        return "patched bitset";
                    }
                };
            }
            case 6: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                if (bitsPerValue != 2 && bitsPerValue != 4) {
                    throw new CorruptIndexException("PATCHED_TABLE only supports bpv=2 and bpv=4, got=" + bitsPerValue, this.data);
                }
                int size = 1 << bitsPerValue;
                int ordsSize = this.data.readVInt();
                final byte[] decode = new byte[ordsSize];
                assert (ordsSize + 1 == size);
                for (int i = 0; i < ordsSize; ++i) {
                    decode[i] = this.data.readByte();
                }
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), packedIntsVersion, entry.count, bitsPerValue);
                final Norms nestedInstance = this.loadNorms(entry.nested);
                return new Norms(){

                    @Override
                    public long get(int docID) {
                        int ord = (int)ordsReader.get(docID);
                        try {
                            return decode[ord];
                        }
                        catch (IndexOutOfBoundsException e2) {
                            return nestedInstance.get(docID);
                        }
                    }

                    @Override
                    public long ramBytesUsed() {
                        return RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed() + nestedInstance.ramBytesUsed();
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        ArrayList<Accountable> children2 = new ArrayList<Accountable>();
                        children2.add(Accountables.namedAccountable("common", ordsReader));
                        children2.add(Accountables.namedAccountable("uncommon", nestedInstance));
                        return Collections.unmodifiableList(children2);
                    }

                    public String toString() {
                        return "patched table";
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public synchronized NormsProducer getMergeInstance() throws IOException {
        return new Lucene50NormsProducer(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ",active=" + this.activeCount.get() + ")";
    }

    static abstract class Norms
    extends NumericDocValues
    implements Accountable {
        Norms() {
        }
    }

    static class NormsEntry {
        byte format;
        long offset;
        int count;
        NormsEntry nested;

        NormsEntry() {
        }
    }
}

