/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;

public class FieldInfos
implements Iterable<FieldInfo> {
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasPayloads;
    private final boolean hasOffsets;
    private final boolean hasVectors;
    private final boolean hasNorms;
    private final boolean hasDocValues;
    private final SortedMap<Integer, FieldInfo> byNumber = new TreeMap<Integer, FieldInfo>();
    private final HashMap<String, FieldInfo> byName = new HashMap();
    private final Collection<FieldInfo> values;

    public FieldInfos(FieldInfo[] infos) {
        boolean hasVectors = false;
        boolean hasProx = false;
        boolean hasPayloads = false;
        boolean hasOffsets = false;
        boolean hasFreq = false;
        boolean hasNorms = false;
        boolean hasDocValues = false;
        for (FieldInfo info2 : infos) {
            if (info2.number < 0) {
                throw new IllegalArgumentException("illegal field number: " + info2.number + " for field " + info2.name);
            }
            FieldInfo previous = this.byNumber.put(info2.number, info2);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field numbers: " + previous.name + " and " + info2.name + " have: " + info2.number);
            }
            previous = this.byName.put(info2.name, info2);
            if (previous != null) {
                throw new IllegalArgumentException("duplicate field names: " + previous.number + " and " + info2.number + " have: " + info2.name);
            }
            hasVectors |= info2.hasVectors();
            hasProx |= info2.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            hasFreq |= info2.getIndexOptions() != IndexOptions.DOCS;
            hasOffsets |= info2.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            hasNorms |= info2.hasNorms();
            hasDocValues |= info2.getDocValuesType() != DocValuesType.NONE;
            hasPayloads |= info2.hasPayloads();
        }
        this.hasVectors = hasVectors;
        this.hasProx = hasProx;
        this.hasPayloads = hasPayloads;
        this.hasOffsets = hasOffsets;
        this.hasFreq = hasFreq;
        this.hasNorms = hasNorms;
        this.hasDocValues = hasDocValues;
        this.values = Collections.unmodifiableCollection(this.byNumber.values());
    }

    public boolean hasFreq() {
        return this.hasFreq;
    }

    public boolean hasProx() {
        return this.hasProx;
    }

    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    public boolean hasOffsets() {
        return this.hasOffsets;
    }

    public boolean hasVectors() {
        return this.hasVectors;
    }

    public boolean hasNorms() {
        return this.hasNorms;
    }

    public boolean hasDocValues() {
        return this.hasDocValues;
    }

    public int size() {
        assert (this.byNumber.size() == this.byName.size());
        return this.byNumber.size();
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.values.iterator();
    }

    public FieldInfo fieldInfo(String fieldName) {
        return this.byName.get(fieldName);
    }

    public FieldInfo fieldInfo(int fieldNumber) {
        if (fieldNumber < 0) {
            throw new IllegalArgumentException("Illegal field number: " + fieldNumber);
        }
        return (FieldInfo)this.byNumber.get(fieldNumber);
    }

    static final class Builder {
        private final HashMap<String, FieldInfo> byName = new HashMap();
        final FieldNumbers globalFieldNumbers;

        Builder() {
            this(new FieldNumbers());
        }

        Builder(FieldNumbers globalFieldNumbers) {
            assert (globalFieldNumbers != null);
            this.globalFieldNumbers = globalFieldNumbers;
        }

        public void add(FieldInfos other) {
            for (FieldInfo fieldInfo : other) {
                this.add(fieldInfo);
            }
        }

        public FieldInfo getOrAdd(String name2) {
            FieldInfo fi = this.fieldInfo(name2);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name2, -1, DocValuesType.NONE);
                fi = new FieldInfo(name2, fieldNumber, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, new HashMap<String, String>());
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, DocValuesType.NONE);
                this.byName.put(fi.name, fi);
            }
            return fi;
        }

        private FieldInfo addOrUpdateInternal(String name2, int preferredFieldNumber, boolean storeTermVector, boolean omitNorms, boolean storePayloads, IndexOptions indexOptions, DocValuesType docValues) {
            if (docValues == null) {
                throw new NullPointerException("DocValuesType cannot be null");
            }
            FieldInfo fi = this.fieldInfo(name2);
            if (fi == null) {
                int fieldNumber = this.globalFieldNumbers.addOrGet(name2, preferredFieldNumber, docValues);
                fi = new FieldInfo(name2, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValues, -1L, new HashMap<String, String>());
                assert (!this.byName.containsKey(fi.name));
                this.globalFieldNumbers.verifyConsistent(fi.number, fi.name, fi.getDocValuesType());
                this.byName.put(fi.name, fi);
            } else {
                fi.update(storeTermVector, omitNorms, storePayloads, indexOptions);
                if (docValues != DocValuesType.NONE) {
                    boolean updateGlobal;
                    boolean bl = updateGlobal = fi.getDocValuesType() == DocValuesType.NONE;
                    if (updateGlobal) {
                        this.globalFieldNumbers.setDocValuesType(fi.number, name2, docValues);
                    }
                    fi.setDocValuesType(docValues);
                }
            }
            return fi;
        }

        public FieldInfo add(FieldInfo fi) {
            return this.addOrUpdateInternal(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), fi.getDocValuesType());
        }

        public FieldInfo fieldInfo(String fieldName) {
            return this.byName.get(fieldName);
        }

        FieldInfos finish() {
            return new FieldInfos(this.byName.values().toArray(new FieldInfo[this.byName.size()]));
        }
    }

    static final class FieldNumbers {
        private final Map<Integer, String> numberToName;
        private final Map<String, Integer> nameToNumber = new HashMap<String, Integer>();
        private final Map<String, DocValuesType> docValuesType;
        private int lowestUnassignedFieldNumber = -1;

        FieldNumbers() {
            this.numberToName = new HashMap<Integer, String>();
            this.docValuesType = new HashMap<String, DocValuesType>();
        }

        synchronized int addOrGet(String fieldName, int preferredFieldNumber, DocValuesType dvType) {
            Integer fieldNumber;
            if (dvType != DocValuesType.NONE) {
                DocValuesType currentDVType = this.docValuesType.get(fieldName);
                if (currentDVType == null) {
                    this.docValuesType.put(fieldName, dvType);
                } else if (currentDVType != DocValuesType.NONE && currentDVType != dvType) {
                    throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + fieldName + "\"");
                }
            }
            if ((fieldNumber = this.nameToNumber.get(fieldName)) == null) {
                Integer preferredBoxed = preferredFieldNumber;
                if (preferredFieldNumber != -1 && !this.numberToName.containsKey(preferredBoxed)) {
                    fieldNumber = preferredBoxed;
                } else {
                    while (this.numberToName.containsKey(++this.lowestUnassignedFieldNumber)) {
                    }
                    fieldNumber = this.lowestUnassignedFieldNumber;
                }
                assert (fieldNumber >= 0);
                this.numberToName.put(fieldNumber, fieldName);
                this.nameToNumber.put(fieldName, fieldNumber);
            }
            return fieldNumber;
        }

        synchronized void verifyConsistent(Integer number, String name2, DocValuesType dvType) {
            if (!name2.equals(this.numberToName.get(number))) {
                throw new IllegalArgumentException("field number " + number + " is already mapped to field name \"" + this.numberToName.get(number) + "\", not \"" + name2 + "\"");
            }
            if (!number.equals(this.nameToNumber.get(name2))) {
                throw new IllegalArgumentException("field name \"" + name2 + "\" is already mapped to field number \"" + this.nameToNumber.get(name2) + "\", not \"" + number + "\"");
            }
            DocValuesType currentDVType = this.docValuesType.get(name2);
            if (dvType != DocValuesType.NONE && currentDVType != null && currentDVType != DocValuesType.NONE && dvType != currentDVType) {
                throw new IllegalArgumentException("cannot change DocValues type from " + (Object)((Object)currentDVType) + " to " + (Object)((Object)dvType) + " for field \"" + name2 + "\"");
            }
        }

        synchronized boolean contains(String fieldName, DocValuesType dvType) {
            if (!this.nameToNumber.containsKey(fieldName)) {
                return false;
            }
            return dvType == this.docValuesType.get(fieldName);
        }

        synchronized void clear() {
            this.numberToName.clear();
            this.nameToNumber.clear();
            this.docValuesType.clear();
        }

        synchronized void setDocValuesType(int number, String name2, DocValuesType dvType) {
            this.verifyConsistent(number, name2, dvType);
            this.docValuesType.put(name2, dvType);
        }
    }
}

