/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.ValueSourceScorer;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public abstract class DocTermsIndexDocValues
extends FunctionValues {
    protected final SortedDocValues termsIndex;
    protected final ValueSource vs;
    protected final MutableValueStr val = new MutableValueStr();
    protected final CharsRefBuilder spareChars = new CharsRefBuilder();

    public DocTermsIndexDocValues(ValueSource vs, LeafReaderContext context, String field) throws IOException {
        this(vs, DocTermsIndexDocValues.open(context, field));
    }

    protected DocTermsIndexDocValues(ValueSource vs, SortedDocValues termsIndex) {
        this.vs = vs;
        this.termsIndex = termsIndex;
    }

    protected abstract String toTerm(String var1);

    @Override
    public boolean exists(int doc2) {
        return this.ordVal(doc2) >= 0;
    }

    @Override
    public int ordVal(int doc2) {
        return this.termsIndex.getOrd(doc2);
    }

    @Override
    public int numOrd() {
        return this.termsIndex.getValueCount();
    }

    @Override
    public boolean bytesVal(int doc2, BytesRefBuilder target) {
        target.clear();
        target.copyBytes(this.termsIndex.get(doc2));
        return target.length() > 0;
    }

    @Override
    public String strVal(int doc2) {
        BytesRef term = this.termsIndex.get(doc2);
        if (term.length == 0) {
            return null;
        }
        this.spareChars.copyUTF8Bytes(term);
        return this.spareChars.toString();
    }

    @Override
    public boolean boolVal(int doc2) {
        return this.exists(doc2);
    }

    @Override
    public abstract Object objectVal(int var1);

    @Override
    public ValueSourceScorer getRangeScorer(IndexReader reader2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        lowerVal = lowerVal == null ? null : this.toTerm(lowerVal);
        upperVal = upperVal == null ? null : this.toTerm(upperVal);
        int lower = Integer.MIN_VALUE;
        if (lowerVal != null) {
            lower = this.termsIndex.lookupTerm(new BytesRef(lowerVal));
            if (lower < 0) {
                lower = -lower - 1;
            } else if (!includeLower) {
                ++lower;
            }
        }
        int upper = Integer.MAX_VALUE;
        if (upperVal != null) {
            upper = this.termsIndex.lookupTerm(new BytesRef(upperVal));
            if (upper < 0) {
                upper = -upper - 2;
            } else if (!includeUpper) {
                --upper;
            }
        }
        final int ll = lower;
        final int uu = upper;
        return new ValueSourceScorer(reader2, this){

            @Override
            public boolean matchesValue(int doc2) {
                int ord = DocTermsIndexDocValues.this.termsIndex.getOrd(doc2);
                return ord >= ll && ord <= uu;
            }
        };
    }

    @Override
    public String toString(int doc2) {
        return this.vs.description() + '=' + this.strVal(doc2);
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueStr mval = new MutableValueStr();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc2) {
                int ord = DocTermsIndexDocValues.this.termsIndex.getOrd(doc2);
                this.mval.value.clear();
                boolean bl = this.mval.exists = ord >= 0;
                if (this.mval.exists) {
                    this.mval.value.copyBytes(DocTermsIndexDocValues.this.termsIndex.lookupOrd(ord));
                }
            }
        };
    }

    static SortedDocValues open(LeafReaderContext context, String field) throws IOException {
        try {
            return DocValues.getSorted(context.reader(), field);
        }
        catch (RuntimeException e2) {
            throw new DocTermsIndexException(field, e2);
        }
    }

    public static final class DocTermsIndexException
    extends RuntimeException {
        public DocTermsIndexException(String fieldName, RuntimeException cause) {
            super("Can't initialize DocTermsIndex to generate (function) FunctionValues for field: " + fieldName, cause);
        }
    }
}

