/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.composite;

import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.prefix.AbstractVisitingPrefixTreeFilter;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;

public class IntersectsRPTVerifyQuery
extends Query {
    private final IntersectsDifferentiatingFilter intersectsDiffFilter;
    private final ValueSource predicateValueSource;

    public IntersectsRPTVerifyQuery(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel, ValueSource predicateValueSource) {
        this.predicateValueSource = predicateValueSource;
        this.intersectsDiffFilter = new IntersectsDifferentiatingFilter(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
    }

    @Override
    public String toString(String field) {
        return "IntersectsVerified(fieldName=" + field + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntersectsRPTVerifyQuery that = (IntersectsRPTVerifyQuery)o;
        if (!this.intersectsDiffFilter.equals(that.intersectsDiffFilter)) {
            return false;
        }
        return this.predicateValueSource.equals(that.predicateValueSource);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.intersectsDiffFilter.hashCode();
        result = 31 * result + this.predicateValueSource.hashCode();
        return result;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Map valueSourceContext = ValueSource.newContext(searcher);
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                BitSet exactDocBits;
                IntersectsDifferentiatingFilter.IntersectsDifferentiatingVisitor result = IntersectsRPTVerifyQuery.this.intersectsDiffFilter.compute(context, acceptDocs);
                if (result.approxDocIdSet == null) {
                    return null;
                }
                final DocIdSetIterator approxDISI = result.approxDocIdSet.iterator();
                if (approxDISI == null) {
                    return null;
                }
                if (result.exactDocIdSet != null) {
                    if (result.approxDocIdSet.equals(result.exactDocIdSet)) {
                        return new ConstantScoreScorer((Weight)this, this.score(), approxDISI);
                    }
                    exactDocBits = result.exactDocIdSet.bits();
                    assert (exactDocBits != null);
                } else {
                    exactDocBits = null;
                }
                final FunctionValues predFuncValues = IntersectsRPTVerifyQuery.this.predicateValueSource.getValues(valueSourceContext, context);
                TwoPhaseIterator twoPhaseIterator = new TwoPhaseIterator(approxDISI){

                    @Override
                    public boolean matches() throws IOException {
                        if (exactDocBits != null && exactDocBits.get(approxDISI.docID())) {
                            return true;
                        }
                        return predFuncValues.boolVal(approxDISI.docID());
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), twoPhaseIterator);
            }
        };
    }

    private static class IntersectsDifferentiatingFilter
    extends AbstractVisitingPrefixTreeFilter {
        public IntersectsDifferentiatingFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel, int prefixGridScanLevel) {
            super(queryShape, fieldName, grid, detailLevel, prefixGridScanLevel);
        }

        IntersectsDifferentiatingVisitor compute(LeafReaderContext context, Bits acceptDocs) throws IOException {
            IntersectsDifferentiatingVisitor result = new IntersectsDifferentiatingVisitor(context, acceptDocs);
            result.getDocIdSet();
            return result;
        }

        @Override
        public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
            throw new IllegalStateException();
        }

        @Override
        public String toString(String field) {
            throw new IllegalStateException();
        }

        class IntersectsDifferentiatingVisitor
        extends AbstractVisitingPrefixTreeFilter.VisitorTemplate {
            BitDocIdSet.Builder approxBuilder;
            BitDocIdSet.Builder exactBuilder;
            BitDocIdSet exactDocIdSet;
            BitDocIdSet approxDocIdSet;

            public IntersectsDifferentiatingVisitor(LeafReaderContext context, Bits acceptDocs) throws IOException {
                super(context, acceptDocs);
                this.approxBuilder = new BitDocIdSet.Builder(this.maxDoc);
                this.exactBuilder = new BitDocIdSet.Builder(this.maxDoc);
            }

            @Override
            protected void start() throws IOException {
            }

            @Override
            protected DocIdSet finish() throws IOException {
                this.exactDocIdSet = this.exactBuilder.build();
                if (this.approxBuilder.isDefinitelyEmpty()) {
                    this.approxDocIdSet = this.exactDocIdSet;
                } else {
                    if (this.exactDocIdSet != null) {
                        this.approxBuilder.or(this.exactDocIdSet.iterator());
                    }
                    this.approxDocIdSet = this.approxBuilder.build();
                }
                return null;
            }

            @Override
            protected boolean visitPrefix(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN) {
                    this.collectDocs(this.exactBuilder);
                    return false;
                }
                if (cell.getLevel() == IntersectsDifferentiatingFilter.this.detailLevel) {
                    this.collectDocs(this.approxBuilder);
                    return false;
                }
                return true;
            }

            @Override
            protected void visitLeaf(Cell cell) throws IOException {
                if (cell.getShapeRel() == SpatialRelation.WITHIN) {
                    this.collectDocs(this.exactBuilder);
                } else {
                    this.collectDocs(this.approxBuilder);
                }
            }
        }
    }
}

