/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.query;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;

public class SpatialArgsParser {
    public static final String DIST_ERR_PCT = "distErrPct";
    public static final String DIST_ERR = "distErr";

    static String writeSpatialArgs(SpatialArgs args) {
        StringBuilder str2 = new StringBuilder();
        str2.append(args.getOperation().getName());
        str2.append('(');
        str2.append(args.getShape().toString());
        if (args.getDistErrPct() != null) {
            str2.append(" distErrPct=").append(String.format(Locale.ROOT, "%.2f%%", args.getDistErrPct() * 100.0));
        }
        if (args.getDistErr() != null) {
            str2.append(" distErr=").append(args.getDistErr());
        }
        str2.append(')');
        return str2.toString();
    }

    public SpatialArgs parse(String v, SpatialContext ctx) throws ParseException, InvalidShapeException {
        int idx = v.indexOf(40);
        int edx = v.lastIndexOf(41);
        if (idx < 0 || idx > edx) {
            throw new ParseException("missing parens: " + v, -1);
        }
        SpatialOperation op = SpatialOperation.get(v.substring(0, idx).trim());
        String body = v.substring(idx + 1, edx).trim();
        if (body.length() < 1) {
            throw new ParseException("missing body : " + v, idx + 1);
        }
        Shape shape = this.parseShape(body, ctx);
        SpatialArgs args = this.newSpatialArgs(op, shape);
        if (v.length() > edx + 1 && (body = v.substring(edx + 1).trim()).length() > 0) {
            Map<String, String> aa = SpatialArgsParser.parseMap(body);
            this.readNameValuePairs(args, aa);
            if (!aa.isEmpty()) {
                throw new IllegalArgumentException("unused parameters: " + aa);
            }
        }
        args.validate();
        return args;
    }

    protected SpatialArgs newSpatialArgs(SpatialOperation op, Shape shape) {
        return new SpatialArgs(op, shape);
    }

    protected void readNameValuePairs(SpatialArgs args, Map<String, String> nameValPairs) {
        args.setDistErrPct(SpatialArgsParser.readDouble(nameValPairs.remove(DIST_ERR_PCT)));
        args.setDistErr(SpatialArgsParser.readDouble(nameValPairs.remove(DIST_ERR)));
    }

    protected Shape parseShape(String str2, SpatialContext ctx) throws ParseException {
        return ctx.readShapeFromWkt(str2);
    }

    protected static Double readDouble(String v) {
        return v == null ? null : Double.valueOf(v);
    }

    protected static boolean readBool(String v, boolean defaultValue) {
        return v == null ? defaultValue : Boolean.parseBoolean(v);
    }

    protected static Map<String, String> parseMap(String body) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(body, " \n\t");
        while (st.hasMoreTokens()) {
            String a = st.nextToken();
            int idx = a.indexOf(61);
            if (idx > 0) {
                String k = a.substring(0, idx);
                String v = a.substring(idx + 1);
                map2.put(k, v);
                continue;
            }
            map2.put(a, a);
        }
        return map2;
    }
}

