/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PriorityQueue;

public final class OfflineSorter {
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long MIN_BUFFER_SIZE_MB = 32L;
    public static final long ABSOLUTE_MIN_SORT_BUFFER_SIZE = 524288L;
    private static final String MIN_BUFFER_SIZE_MSG = "At least 0.5MB RAM buffer is needed";
    public static final int MAX_TEMPFILES = 128;
    private final BufferSize ramBufferSize;
    private final Path tempDirectory;
    private final Counter bufferBytesUsed = Counter.newCounter();
    private final BytesRefArray buffer = new BytesRefArray(this.bufferBytesUsed);
    private SortInfo sortInfo;
    private int maxTempFiles;
    private final Comparator<BytesRef> comparator;
    public static final Comparator<BytesRef> DEFAULT_COMPARATOR = BytesRef.getUTF8SortedAsUnicodeComparator();

    public OfflineSorter() throws IOException {
        this(DEFAULT_COMPARATOR, BufferSize.automatic(), OfflineSorter.defaultTempDir(), 128);
    }

    public OfflineSorter(Comparator<BytesRef> comparator2) throws IOException {
        this(comparator2, BufferSize.automatic(), OfflineSorter.defaultTempDir(), 128);
    }

    public OfflineSorter(Comparator<BytesRef> comparator2, BufferSize ramBufferSize, Path tempDirectory, int maxTempfiles) {
        if ((long)ramBufferSize.bytes < 524288L) {
            throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + ramBufferSize.bytes);
        }
        if (maxTempfiles < 2) {
            throw new IllegalArgumentException("maxTempFiles must be >= 2");
        }
        this.ramBufferSize = ramBufferSize;
        this.tempDirectory = tempDirectory;
        this.maxTempFiles = maxTempfiles;
        this.comparator = comparator2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortInfo sort(Path input, Path output) throws IOException {
        block22: {
            ArrayList<Path> merges;
            block20: {
                this.sortInfo = new SortInfo();
                this.sortInfo.totalTime = System.currentTimeMillis();
                Files.deleteIfExists(output);
                merges = new ArrayList<Path>();
                boolean success3 = false;
                try {
                    block21: {
                        ByteSequencesReader is2;
                        block19: {
                            is2 = new ByteSequencesReader(input);
                            boolean success = false;
                            try {
                                int lines = 0;
                                while ((lines = this.readPartition(is2)) > 0) {
                                    merges.add(this.sortPartition(lines));
                                    ++this.sortInfo.tempMergeFiles;
                                    this.sortInfo.lines += lines;
                                    if (merges.size() != this.maxTempFiles) continue;
                                    Path intermediate = Files.createTempFile(this.tempDirectory, "sort", "intermediate", new FileAttribute[0]);
                                    boolean success2 = false;
                                    try {
                                        this.mergePartitions(merges, intermediate);
                                        success2 = true;
                                    }
                                    finally {
                                        if (success2) {
                                            IOUtils.deleteFilesIfExist(merges);
                                        } else {
                                            IOUtils.deleteFilesIgnoringExceptions(merges);
                                        }
                                        merges.clear();
                                        merges.add(intermediate);
                                    }
                                    ++this.sortInfo.tempMergeFiles;
                                }
                                success = true;
                                if (!success) break block19;
                            }
                            catch (Throwable throwable) {
                                if (success) {
                                    IOUtils.close(is2);
                                } else {
                                    IOUtils.closeWhileHandlingException(is2);
                                }
                                throw throwable;
                            }
                            IOUtils.close(is2);
                            break block21;
                        }
                        IOUtils.closeWhileHandlingException(is2);
                    }
                    if (merges.size() == 1) {
                        Path single = (Path)merges.get(0);
                        try {
                            Files.move(single, output, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (IOException | UnsupportedOperationException e2) {
                            Files.copy(single, output, new CopyOption[0]);
                        }
                    } else {
                        this.mergePartitions(merges, output);
                    }
                    success3 = true;
                    if (!success3) break block20;
                }
                catch (Throwable throwable) {
                    if (success3) {
                        IOUtils.deleteFilesIfExist(merges);
                    } else {
                        IOUtils.deleteFilesIgnoringExceptions(merges);
                        IOUtils.deleteFilesIgnoringExceptions(output);
                    }
                    throw throwable;
                }
                IOUtils.deleteFilesIfExist(merges);
                break block22;
            }
            IOUtils.deleteFilesIgnoringExceptions(merges);
            IOUtils.deleteFilesIgnoringExceptions(output);
        }
        this.sortInfo.totalTime = System.currentTimeMillis() - this.sortInfo.totalTime;
        return this.sortInfo;
    }

    public static Path defaultTempDir() throws IOException {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            throw new IOException("Java has no temporary folder property (java.io.tmpdir)?");
        }
        Path tempDirectory = Paths.get(tempDirPath, new String[0]);
        if (!Files.isWritable(tempDirectory)) {
            throw new IOException("Java's temporary folder not present or writeable?: " + tempDirectory.toAbsolutePath());
        }
        return tempDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path sortPartition(int len) throws IOException {
        Path path2;
        BytesRefArray data2 = this.buffer;
        Path tempFile = Files.createTempFile(this.tempDirectory, "sort", "partition", new FileAttribute[0]);
        long start = System.currentTimeMillis();
        this.sortInfo.sortTime += System.currentTimeMillis() - start;
        ByteSequencesWriter out = new ByteSequencesWriter(tempFile);
        try {
            BytesRef spare;
            BytesRefIterator iter = this.buffer.iterator(this.comparator);
            while ((spare = iter.next()) != null) {
                assert (spare.length <= Short.MAX_VALUE);
                out.write(spare);
            }
            out.close();
            data2.clear();
            path2 = tempFile;
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergePartitions(List<Path> merges, Path outputFile) throws IOException {
        long start = System.currentTimeMillis();
        ByteSequencesWriter out = new ByteSequencesWriter(outputFile);
        PriorityQueue<FileAndTop> queue = new PriorityQueue<FileAndTop>(merges.size()){

            @Override
            protected boolean lessThan(FileAndTop a, FileAndTop b) {
                return OfflineSorter.this.comparator.compare(a.current.get(), b.current.get()) < 0;
            }
        };
        Closeable[] streams = new ByteSequencesReader[merges.size()];
        try {
            FileAndTop top;
            for (int i = 0; i < merges.size(); ++i) {
                streams[i] = new ByteSequencesReader(merges.get(i));
                byte[] line = ((ByteSequencesReader)streams[i]).read();
                if (line == null) continue;
                queue.insertWithOverflow(new FileAndTop(i, line));
            }
            while ((top = (FileAndTop)queue.top()) != null) {
                out.write(top.current.bytes(), 0, top.current.length());
                if (!((ByteSequencesReader)streams[top.fd]).read(top.current)) {
                    queue.pop();
                    continue;
                }
                queue.updateTop();
            }
            this.sortInfo.mergeTime += System.currentTimeMillis() - start;
            ++this.sortInfo.mergeRounds;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.close(streams);
            }
            catch (Throwable throwable2) {
                IOUtils.close(out);
                throw throwable2;
            }
            IOUtils.close(out);
            throw throwable;
        }
        try {
            IOUtils.close(streams);
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close(out);
    }

    int readPartition(ByteSequencesReader reader2) throws IOException {
        long start = System.currentTimeMillis();
        BytesRef scratch = new BytesRef();
        while ((scratch.bytes = reader2.read()) != null) {
            scratch.length = scratch.bytes.length;
            this.buffer.append(scratch);
            if ((long)this.ramBufferSize.bytes >= this.bufferBytesUsed.get()) continue;
        }
        this.sortInfo.readTime += System.currentTimeMillis() - start;
        return this.buffer.size();
    }

    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    public static class ByteSequencesReader
    implements Closeable {
        private final DataInput is;

        public ByteSequencesReader(Path path2) throws IOException {
            this(new DataInputStream(new BufferedInputStream(Files.newInputStream(path2, new OpenOption[0]))));
        }

        public ByteSequencesReader(DataInput is2) {
            this.is = is2;
        }

        public boolean read(BytesRefBuilder ref2) throws IOException {
            short length;
            try {
                length = this.is.readShort();
            }
            catch (EOFException e2) {
                return false;
            }
            ref2.grow(length);
            ref2.setLength(length);
            this.is.readFully(ref2.bytes(), 0, length);
            return true;
        }

        public byte[] read() throws IOException {
            short length;
            try {
                length = this.is.readShort();
            }
            catch (EOFException e2) {
                return null;
            }
            assert (length >= 0) : "Sanity: sequence length < 0: " + length;
            byte[] result = new byte[length];
            this.is.readFully(result);
            return result;
        }

        @Override
        public void close() throws IOException {
            if (this.is instanceof Closeable) {
                ((Closeable)((Object)this.is)).close();
            }
        }
    }

    public static class ByteSequencesWriter
    implements Closeable {
        private final DataOutput os;

        public ByteSequencesWriter(Path path2) throws IOException {
            this(new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0]))));
        }

        public ByteSequencesWriter(DataOutput os) {
            this.os = os;
        }

        public void write(BytesRef ref2) throws IOException {
            assert (ref2 != null);
            this.write(ref2.bytes, ref2.offset, ref2.length);
        }

        public void write(byte[] bytes2) throws IOException {
            this.write(bytes2, 0, bytes2.length);
        }

        public void write(byte[] bytes2, int off, int len) throws IOException {
            assert (bytes2 != null);
            assert (off >= 0 && off + len <= bytes2.length);
            assert (len >= 0);
            if (len > Short.MAX_VALUE) {
                throw new IllegalArgumentException("len must be <= 32767; got " + len);
            }
            this.os.writeShort(len);
            this.os.write(bytes2, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this.os instanceof Closeable) {
                ((Closeable)((Object)this.os)).close();
            }
        }
    }

    static class FileAndTop {
        final int fd;
        final BytesRefBuilder current;

        FileAndTop(int fd, byte[] firstLine) {
            this.fd = fd;
            this.current = new BytesRefBuilder();
            this.current.copyBytes(firstLine, 0, firstLine.length);
        }
    }

    public class SortInfo {
        public int tempMergeFiles;
        public int mergeRounds;
        public int lines;
        public long mergeTime;
        public long sortTime;
        public long totalTime;
        public long readTime;
        public final long bufferSize;

        public SortInfo() {
            this.bufferSize = ((OfflineSorter)OfflineSorter.this).ramBufferSize.bytes;
        }

        public String toString() {
            return String.format(Locale.ROOT, "time=%.2f sec. total (%.2f reading, %.2f sorting, %.2f merging), lines=%d, temp files=%d, merges=%d, soft ram limit=%.2f MB", (double)this.totalTime / 1000.0, (double)this.readTime / 1000.0, (double)this.sortTime / 1000.0, (double)this.mergeTime / 1000.0, this.lines, this.tempMergeFiles, this.mergeRounds, (double)this.bufferSize / 1048576.0);
        }
    }

    public static final class BufferSize {
        final int bytes;

        private BufferSize(long bytes2) {
            if (bytes2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Buffer too large for Java (2047mb max): " + bytes2);
            }
            if (bytes2 < 524288L) {
                throw new IllegalArgumentException("At least 0.5MB RAM buffer is needed: " + bytes2);
            }
            this.bytes = (int)bytes2;
        }

        public static BufferSize megabytes(long mb) {
            return new BufferSize(mb * 0x100000L);
        }

        public static BufferSize automatic() {
            Runtime rt = Runtime.getRuntime();
            long max2 = rt.maxMemory();
            long total = rt.totalMemory();
            long free = rt.freeMemory();
            long totalAvailableBytes = max2 - total + free;
            long sortBufferByteSize = free / 2L;
            long minBufferSizeBytes = 0x2000000L;
            if (sortBufferByteSize < 0x2000000L || totalAvailableBytes > 0x14000000L) {
                sortBufferByteSize = totalAvailableBytes / 2L > 0x2000000L ? totalAvailableBytes / 2L : Math.max(524288L, sortBufferByteSize);
            }
            return new BufferSize(Math.min(Integer.MAX_VALUE, sortBufferByteSize));
        }
    }
}

