/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;

public class IOUtil {
    public static String readString(File file2) throws IOException {
        try (FileInputStream in = new FileInputStream(file2);){
            String string2 = IOUtil.readString(in);
            return string2;
        }
    }

    public static String readString(URL url) throws IOException {
        try (Reader reader2 = IOUtil.urlToReader(url);){
            String string2 = IOUtil.readString(reader2);
            return string2;
        }
    }

    public static String readString(InputStream in) throws IOException {
        return IOUtil.readString(new InputStreamReader(in));
    }

    public static String readString(Reader r) throws IOException {
        return IOUtil.readFully(r).toString();
    }

    public static String readString(Reader r, int maxChars) throws IOException {
        char[] charBuf = new char[maxChars];
        int charsRead = IOUtil.readChars(r, charBuf);
        return new String(charBuf, 0, charsRead);
    }

    public static char[] readChars(URL url) throws IOException {
        try (Reader reader2 = IOUtil.urlToReader(url);){
            char[] cArray = IOUtil.readChars(reader2);
            return cArray;
        }
    }

    public static char[] readChars(Reader r) throws IOException {
        return IOUtil.readFully(r).toCharArray();
    }

    public static int readChars(Reader r, char[] charArray) throws IOException {
        int totalCharsRead = 0;
        int charsRead = r.read(charArray);
        while (charsRead >= 0 && (totalCharsRead += charsRead) != charArray.length) {
            charsRead = r.read(charArray, totalCharsRead, charArray.length - totalCharsRead);
        }
        return totalCharsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file2) throws IOException {
        long fileSize = file2.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size exceeds maximum array length (" + fileSize + " > " + Integer.MAX_VALUE + ")");
        }
        try (FileInputStream in = new FileInputStream(file2);){
            byte[] byArray = IOUtil.readBytes((InputStream)in, (int)fileSize);
            return byArray;
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        IOUtil.transfer(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int maxBytes) throws IOException {
        byte[] result = new byte[maxBytes];
        int bytesRead = IOUtil.readBytes(in, result);
        if (bytesRead < maxBytes) {
            byte[] tmp = new byte[bytesRead];
            System.arraycopy(result, 0, tmp, 0, bytesRead);
            result = tmp;
        }
        return result;
    }

    public static int readBytes(InputStream in, byte[] byteArray) throws IOException {
        int totalBytesRead = 0;
        int bytesRead = in.read(byteArray);
        while (bytesRead >= 0 && (totalBytesRead += bytesRead) != byteArray.length) {
            bytesRead = in.read(byteArray, totalBytesRead, byteArray.length - totalBytesRead);
        }
        return totalBytesRead;
    }

    public static Properties readProperties(File propsFile) throws IOException {
        return IOUtil.readProperties(propsFile, null);
    }

    public static Properties readProperties(File propsFile, Properties defaults) throws IOException {
        return IOUtil.readProperties(new FileInputStream(propsFile), defaults);
    }

    public static Properties readProperties(InputStream in) throws IOException {
        return IOUtil.readProperties(in, null);
    }

    public static Properties readProperties(InputStream in, Properties defaults) throws IOException {
        Properties result = new Properties(defaults);
        try {
            result.load(in);
        }
        finally {
            in.close();
        }
        return result;
    }

    public static void writeProperties(Properties props, File file2, boolean includeDefaults) throws IOException {
        IOUtil.writeProperties(props, new FileOutputStream(file2), includeDefaults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(Properties props, OutputStream out, boolean includeDefaults) throws IOException {
        if (includeDefaults) {
            Properties all = new Properties();
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                all.put(propName, propValue);
            }
            props = all;
        }
        try {
            props.store(out, null);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream in, File file2) throws IOException {
        FileOutputStream out = new FileOutputStream(file2);
        try {
            IOUtil.transfer(in, out);
        }
        finally {
            try {
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    public static void writeString(String contents, File file2) throws IOException {
        try (FileWriter out = new FileWriter(file2);){
            out.write(contents);
        }
    }

    public static void writeBytes(byte[] data2, File file2) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file2);){
            IOUtil.writeBytes(data2, out);
        }
    }

    public static void writeBytes(byte[] data2, OutputStream out) throws IOException {
        IOUtil.transfer((InputStream)new ByteArrayInputStream(data2), out);
    }

    public static Reader urlToReader(URL url) throws IOException {
        URLConnection con = url.openConnection();
        return new InputStreamReader(con.getInputStream());
    }

    private static CharArrayWriter readFully(Reader r) throws IOException {
        CharArrayWriter result = new CharArrayWriter();
        char[] buf = new char[4096];
        int charsRead = 0;
        while ((charsRead = r.read(buf)) != -1) {
            result.write(buf, 0, charsRead);
        }
        return result;
    }

    public static final long transfer(InputStream in, OutputStream out) throws IOException {
        long totalBytes = 0L;
        int bytesInBuf = 0;
        byte[] buf = new byte[4096];
        while ((bytesInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, bytesInBuf);
            totalBytes += (long)bytesInBuf;
        }
        return totalBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transfer(InputStream in, File file2) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file2);){
            long l = IOUtil.transfer(in, out);
            return l;
        }
    }

    public static final long transfer(Reader in, Writer out) throws IOException {
        long totalChars = 0L;
        int charsInBuf = 0;
        char[] buf = new char[4096];
        while ((charsInBuf = in.read(buf)) != -1) {
            out.write(buf, 0, charsInBuf);
            totalChars += (long)charsInBuf;
        }
        return totalChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long transfer(Reader reader2, File file2) throws IOException {
        try (FileWriter writer2 = new FileWriter(file2);){
            long l = IOUtil.transfer(reader2, writer2);
            return l;
        }
    }
}

