/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.federation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.JoinExecutorBase;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceFallbackIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinConversionIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.CollectionIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.CrossProductIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.SilentIteration;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.InsertBindingSetCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFederatedService
implements FederatedService {
    static final Logger logger = LoggerFactory.getLogger(RepositoryFederatedService.class);
    protected final Repository rep;
    protected boolean shutDown = true;
    protected RepositoryConnection conn = null;

    public RepositoryFederatedService(Repository repo) {
        this(repo, true);
    }

    public RepositoryFederatedService(Repository repo, boolean shutDown) {
        this.rep = repo;
        this.shutDown = shutDown;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> select(Service service, Set<String> projectionVars, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        try {
            String sparqlQueryString = service.getSelectQueryString(projectionVars);
            TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
            for (Binding b : bindings) {
                if (!service.getServiceVars().contains(b.getName())) continue;
                query.setBinding(b.getName(), b.getValue());
            }
            TupleQueryResult res = query.evaluate();
            return new InsertBindingSetCursor(res, bindings);
        }
        catch (MalformedQueryException e2) {
            throw new QueryEvaluationException(e2);
        }
        catch (RepositoryException e3) {
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", e3);
        }
    }

    @Override
    public boolean ask(Service service, BindingSet bindings, String baseUri) throws QueryEvaluationException {
        try {
            String sparqlQueryString = service.getAskQueryString();
            BooleanQuery query = this.getConnection().prepareBooleanQuery(QueryLanguage.SPARQL, sparqlQueryString, baseUri);
            for (Binding b : bindings) {
                if (!service.getServiceVars().contains(b.getName())) continue;
                query.setBinding(b.getName(), b.getValue());
            }
            return query.evaluate();
        }
        catch (MalformedQueryException e2) {
            throw new QueryEvaluationException(e2);
        }
        catch (RepositoryException e3) {
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", e3);
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        int blockSize = 15;
        if (blockSize > 0) {
            return new BatchingServiceIteration(bindings, blockSize, service);
        }
        return this.evaluateInternal(service, bindings, service.getBaseURI());
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternal(Service service, CloseableIteration<BindingSet, QueryEvaluationException> bindings, String baseUri) throws QueryEvaluationException {
        LinkedList<BindingSet> allBindings = new LinkedList<BindingSet>();
        while (bindings.hasNext()) {
            allBindings.add((BindingSet)bindings.next());
        }
        if (allBindings.size() == 0) {
            return new EmptyIteration<BindingSet, QueryEvaluationException>();
        }
        HashSet<String> projectionVars = new HashSet<String>(service.getServiceVars());
        projectionVars.removeAll(((BindingSet)allBindings.get(0)).getBindingNames());
        AbstractCloseableIteration result = null;
        try {
            if (allBindings.size() == 1) {
                result = this.select(service, projectionVars, (BindingSet)allBindings.get(0), baseUri);
                result = service.isSilent() ? new SilentIteration(result) : result;
                return result;
            }
            projectionVars.add("__rowIdx");
            String queryString = service.getSelectQueryString(projectionVars);
            List<String> relevantBindingNames = this.getRelevantBindingNames(allBindings, service.getServiceVars());
            if (relevantBindingNames.size() != 0) {
                queryString = queryString + this.buildVALUESClause(allBindings, relevantBindingNames);
            }
            TupleQuery query = this.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, queryString, baseUri);
            TupleQueryResult res = null;
            try {
                query.setMaxQueryTime(60);
                res = query.evaluate();
            }
            catch (QueryEvaluationException q) {
                this.closeQuietly(res);
                result = new ServiceFallbackIteration(service, projectionVars, allBindings, this);
                result = service.isSilent() ? new SilentIteration(result) : result;
                return result;
            }
            result = relevantBindingNames.size() == 0 ? new CrossProductIteration(res, allBindings) : new ServiceJoinConversionIteration(res, allBindings);
            result = service.isSilent() ? new SilentIteration(result) : result;
            return result;
        }
        catch (RepositoryException e2) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw new QueryEvaluationException("Repository for endpoint " + this.rep.toString() + " could not be initialized.", e2);
        }
        catch (MalformedQueryException e3) {
            throw new QueryEvaluationException(e3);
        }
        catch (QueryEvaluationException e4) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw e4;
        }
        catch (RuntimeException e5) {
            Iterations.closeCloseable(result);
            if (service.isSilent()) {
                return new CollectionIteration<BindingSet, QueryEvaluationException>(allBindings);
            }
            throw e5;
        }
    }

    @Override
    public void initialize() throws QueryEvaluationException {
        try {
            this.rep.initialize();
        }
        catch (RepositoryException e2) {
            throw new QueryEvaluationException(e2);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.rep.isInitialized();
    }

    private void closeQuietly(TupleQueryResult res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e2) {
            logger.debug("Could not close connection properly: " + e2.getMessage(), e2);
        }
    }

    @Override
    public void shutdown() throws QueryEvaluationException {
        boolean foundException = false;
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (RepositoryException e2) {
            foundException = true;
            throw new QueryEvaluationException(e2);
        }
        finally {
            block12: {
                try {
                    if (this.shutDown) {
                        this.rep.shutDown();
                    }
                }
                catch (RepositoryException e3) {
                    if (foundException) break block12;
                    throw new QueryEvaluationException(e3);
                }
            }
        }
    }

    protected RepositoryConnection getConnection() throws RepositoryException {
        if (this.conn == null) {
            this.conn = this.rep.getConnection();
        }
        return this.conn;
    }

    private List<String> getRelevantBindingNames(List<BindingSet> bindings, Set<String> serviceVars) {
        ArrayList<String> relevantBindingNames = new ArrayList<String>(5);
        for (String bName : bindings.get(0).getBindingNames()) {
            if (!serviceVars.contains(bName)) continue;
            relevantBindingNames.add(bName);
        }
        return relevantBindingNames;
    }

    private String buildVALUESClause(List<BindingSet> bindings, List<String> relevantBindingNames) throws QueryEvaluationException {
        StringBuilder sb = new StringBuilder();
        sb.append(" VALUES (?__rowIdx");
        for (String bName : relevantBindingNames) {
            sb.append(" ?").append(bName);
        }
        sb.append(") { ");
        int rowIdx = 0;
        for (BindingSet b : bindings) {
            sb.append(" (");
            sb.append("\"").append(rowIdx++).append("\" ");
            for (String bName : relevantBindingNames) {
                this.appendValueAsString(sb, b.getValue(bName)).append(" ");
            }
            sb.append(")");
        }
        sb.append(" }");
        return sb.toString();
    }

    protected StringBuilder appendValueAsString(StringBuilder sb, Value value) {
        if (value == null) {
            return sb.append("UNDEF");
        }
        if (value instanceof URI) {
            return RepositoryFederatedService.appendURI(sb, (URI)value);
        }
        if (value instanceof Literal) {
            return RepositoryFederatedService.appendLiteral(sb, (Literal)value);
        }
        throw new RuntimeException("Type not supported: " + value.getClass().getCanonicalName());
    }

    protected static StringBuilder appendURI(StringBuilder sb, URI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    protected static StringBuilder appendLiteral(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (Literals.isLanguageLiteral(lit)) {
            sb.append('@');
            sb.append(lit.getLanguage());
        } else {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }

    private class BatchingServiceIteration
    extends JoinExecutorBase<BindingSet> {
        private final int blockSize;
        private final Service service;

        public BatchingServiceIteration(CloseableIteration<BindingSet, QueryEvaluationException> inputBindings, int blockSize, Service service) throws QueryEvaluationException {
            super(inputBindings, null, EmptyBindingSet.getInstance());
            this.blockSize = blockSize;
            this.service = service;
            this.run();
        }

        @Override
        protected void handleBindings() throws Exception {
            while (!this.isClosed() && this.leftIter.hasNext()) {
                ArrayList blockBindings = new ArrayList(this.blockSize);
                for (int i = 0; i < this.blockSize && this.leftIter.hasNext(); ++i) {
                    blockBindings.add(this.leftIter.next());
                }
                CollectionIteration<BindingSet, QueryEvaluationException> materializedIter = new CollectionIteration<BindingSet, QueryEvaluationException>(blockBindings);
                this.addResult(RepositoryFederatedService.this.evaluateInternal(this.service, materializedIter, this.service.getBaseURI()));
            }
        }
    }
}

