/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.io.UnsupportedEncodingException;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class EncodeForUri
implements Function {
    @Override
    public String getURI() {
        return FN.ENCODE_FOR_URI.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("ENCODE_FOR_URI requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String lexValue = literal.getLabel();
                return valueFactory.createLiteral(this.encodeUri(lexValue));
            }
            throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + literal);
        }
        throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + args[0]);
    }

    private String encodeUri(String uri) {
        StringBuilder buf = new StringBuilder(uri.length() * 2);
        int uriLen = uri.length();
        for (int i = 0; i < uriLen; ++i) {
            char c = uri.charAt(i);
            if (this.isUnreserved(c)) {
                buf.append(c);
                continue;
            }
            try {
                byte[] utf8;
                for (byte b : utf8 = Character.toString(c).getBytes("UTF-8")) {
                    buf.append('%');
                    char cb = (char)(b & 0xFF);
                    String hexVal = Integer.toHexString(cb).toUpperCase();
                    if (hexVal.length() == 1) {
                        buf.append('0');
                    }
                    buf.append(hexVal);
                }
                continue;
            }
            catch (UnsupportedEncodingException e2) {
                throw new RuntimeException(e2);
            }
        }
        return buf.toString();
    }

    private final boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }
}

