/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RemoteRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;

public class RepositoryProvider {
    private static final String REPOSITORIES = "repositories/";
    static final Map<String, SynchronizedManager> managers = new HashMap<String, SynchronizedManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryManager getRepositoryManager(String url) throws RepositoryConfigException, RepositoryException {
        String uri = RepositoryProvider.normalizeDirectory(url);
        SynchronizedManager sync2 = null;
        Map<String, SynchronizedManager> map2 = managers;
        synchronized (map2) {
            Iterator<SynchronizedManager> iter = managers.values().iterator();
            while (iter.hasNext()) {
                SynchronizedManager sm = iter.next();
                if (sm.isInitialized()) continue;
                sm.shutDown();
                iter.remove();
            }
            if (managers.containsKey(uri)) {
                sync2 = managers.get(uri);
            } else {
                sync2 = new SynchronizedManager(url);
                managers.put(uri, sync2);
            }
        }
        return sync2.get();
    }

    public static LocalRepositoryManager getRepositoryManager(File dir2) throws RepositoryConfigException, RepositoryException {
        String url = dir2.toURI().toASCIIString();
        return (LocalRepositoryManager)RepositoryProvider.getRepositoryManager(url);
    }

    public static RepositoryManager getRepositoryManagerOfRepository(String url) throws RepositoryConfigException, RepositoryException {
        if (!url.contains(REPOSITORIES)) {
            throw new IllegalArgumentException("URL is not repository URL: " + url);
        }
        int idx = url.lastIndexOf(REPOSITORIES);
        String server2 = url.substring(0, idx);
        if (server2.length() == 0) {
            server2 = ".";
        }
        return RepositoryProvider.getRepositoryManager(server2);
    }

    public static String getRepositoryIdOfRepository(String url) {
        if (!url.contains(REPOSITORIES)) {
            throw new IllegalArgumentException("URL is not repository URL: " + url);
        }
        int idx = url.lastIndexOf(REPOSITORIES);
        String id = url.substring(idx + REPOSITORIES.length());
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    public static Repository getRepository(String url) throws RepositoryException, RepositoryConfigException {
        RepositoryManager manager = RepositoryProvider.getRepositoryManagerOfRepository(url);
        String id = RepositoryProvider.getRepositoryIdOfRepository(url);
        return manager.getRepository(id);
    }

    static RepositoryManager createRepositoryManager(String url) throws RepositoryConfigException {
        if (url.startsWith("http")) {
            return new RemoteRepositoryManager(url);
        }
        return new LocalRepositoryManager(RepositoryProvider.asLocalFile(url));
    }

    private static File asLocalFile(String url) throws RepositoryConfigException {
        URI uri = new File(".").toURI().resolve(url);
        return new File(uri);
    }

    private static String normalizeDirectory(String url) throws IllegalArgumentException {
        try {
            if (!url.endsWith("/")) {
                return RepositoryProvider.normalizeDirectory(url + '/');
            }
            URI norm = URI.create(url);
            if (!norm.isAbsolute()) {
                norm = new File(".").toURI().resolve(url);
            }
            if ((norm = norm.normalize()).isOpaque()) {
                throw new IllegalArgumentException("Repository Manager URL must not be opaque: " + url);
            }
            String sch = norm.getScheme();
            String host = norm.getAuthority();
            String path2 = norm.getPath();
            if (sch != null) {
                sch = sch.toLowerCase();
            }
            if (host != null) {
                host = host.toLowerCase();
            }
            return new URI(sch, host, path2, null, null).toASCIIString();
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("RepositoryProvider-shutdownHook"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map<String, SynchronizedManager> map2 = managers;
                synchronized (map2) {
                    for (SynchronizedManager manager : managers.values()) {
                        manager.shutDown();
                    }
                }
            }
        });
    }

    private static class SynchronizedManager {
        private final String url;
        private RepositoryManager manager;

        public SynchronizedManager(String url) {
            this.url = url;
        }

        public synchronized RepositoryManager get() throws RepositoryConfigException, RepositoryException {
            if (this.manager == null || !this.manager.isInitialized()) {
                this.shutDown();
                RepositoryManager m = RepositoryProvider.createRepositoryManager(this.url);
                m.initialize();
                this.manager = m;
            }
            return this.manager;
        }

        public synchronized boolean isInitialized() {
            return this.manager != null && this.manager.isInitialized();
        }

        public synchronized void shutDown() {
            if (this.manager != null) {
                this.manager.shutDown();
            }
        }
    }
}

